/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.annotator;

import edu.sysu.pmglab.ccf.CCFTable;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.toolkit.Processor;
import edu.sysu.pmglab.ccf.toolkit.annotator.GTBDatabase;
import edu.sysu.pmglab.ccf.toolkit.converter.ILiteConverter;
import edu.sysu.pmglab.ccf.toolkit.input.TextInputOption;
import edu.sysu.pmglab.ccf.toolkit.listener.InputListener;
import edu.sysu.pmglab.ccf.toolkit.listener.OutputListener;
import edu.sysu.pmglab.ccf.toolkit.listener.SortListener;
import edu.sysu.pmglab.ccf.toolkit.output.GTBOutputOption;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.container.indexable.FixedIndexableMap;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.genome.coordinate.Coordinate;
import edu.sysu.pmglab.gtb.genome.coordinate.liftover.LiftOver;
import edu.sysu.pmglab.gtb.toolkit.GTBIndexer;
import edu.sysu.pmglab.gtb.toolkit.GTBSorter;
import edu.sysu.pmglab.gtb.toolkit.annotator.DatabaseField;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.file.LocalFile;
import edu.sysu.pmglab.io.text.TextRecord;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public final class RegBase
extends GTBDatabase {
    public RegBase(String option) throws IOException {
        super(option);
    }

    public RegBase(File option) throws IOException {
        super(option);
    }

    public RegBase(LiveFile option) throws IOException {
        super(option);
    }

    public RegBase(CCFTable option) throws IOException {
        super(option);
    }

    public RegBase(GTBManager option) throws IOException {
        super(option);
    }

    public RegBase(GTBReaderOption option) {
        super(option);
    }

    public RegBase(GTBReaderOption option, IFieldCollection fields, ICCFMeta meta) {
        super(option, fields, meta);
    }

    public static InputSetting buildFrom(String file) throws IOException {
        return new InputSetting(LiveFile.of(file));
    }

    public static InputSetting buildFrom(File file) throws IOException {
        return new InputSetting(new LocalFile(file));
    }

    public static InputSetting buildFrom(LiveFile file) {
        return new InputSetting(file);
    }

    @Override
    public boolean contains(Variant variant) {
        return variant.numOfAlleles() == 2 && variant.alleleOfIndex(0).length() == 1 && variant.alleleOfIndex(1).length() == 1;
    }

    @Override
    public String getDatabaseName() {
        return "regBase";
    }

    public static class OutputSetting {
        final LiveFile inputFile;
        final File output;
        private final List<DatabaseField> FIELDS = List.wrap(new DatabaseField[]{new DatabaseField(FieldMeta.of("regBase", "REG", FieldType.float16), "REG").addDescription("Description", "\"regBase_REG is a composite prediction model to score functional SNVs from existing tools for base-wise annotation of human genome.\""), new DatabaseField(FieldMeta.of("regBase", "REG_PHRED", FieldType.float16), "REG_PHRED").addDescription("Description", "\"The phred-link score value of REG.\""), new DatabaseField(FieldMeta.of("regBase", "CAN", FieldType.float16), "CAN").addDescription("Description", "\"regBase_CAN is a composite prediction model to score cancer driver non-coding regulatory SNVs from existing tools for base-wise annotation of human genome.\""), new DatabaseField(FieldMeta.of("regBase", "CAN_PHRED", FieldType.float16), "CAN_PHRED").addDescription("Description", "\"The phred-link score value of CAN.\""), new DatabaseField(FieldMeta.of("regBase", "PAT", FieldType.float16), "PAT").addDescription("Description", "\"regBase_PAT is a composite prediction model to score pathogenic SNVs from existing tools for base-wise annotation of human genome. The larger the score the more likely the SNP has damaging effect.\""), new DatabaseField(FieldMeta.of("regBase", "PAT_PHRED", FieldType.float16), "PAT_PHRED").addDescription("Description", "\"The phred-link score value of PAT.\"")}).asUnmodifiable();
        LiftOver liftover = LiftOver.ITSELF;
        boolean resume = true;
        boolean silent = false;

        private OutputSetting(LiveFile inputFile, File output) {
            this.inputFile = inputFile;
            this.output = output;
        }

        public OutputSetting liftover(LiftOver liftOver) {
            this.liftover = liftOver == null ? LiftOver.ITSELF : liftOver;
            return this;
        }

        public OutputSetting resume(boolean resume) {
            this.resume = resume;
            return this;
        }

        public OutputSetting silent(boolean silent) {
            this.silent = silent;
            return this;
        }

        public void build(int threads) throws IOException {
            if (this.resume && this.output.exists()) {
                return;
            }
            Processor.setInput(new TextInputOption(this.inputFile)).setOutput(new GTBOutputOption(this.output).addFields(this.FIELDS.apply(DatabaseField::getField)).addMeta(CCFMetaItem.of("Database", "<Name=regBase,Description=\"regBase is a database that provides regulatory annotations for genetic variants, aiding in the interpretation of non-coding variants by integrating data from various sources to predict regulatory functions.\",Source=\"" + this.inputFile + "\">")).addMeta(this.FIELDS.apply(DatabaseField::getMeta))).bridge(new ILiteConverter<TextRecord, Variant>(){
                final ThreadLocal<Map<String, Object>> properties = ThreadLocal.withInitial(() -> new FixedIndexableMap(FIELDS.apply(databaseField -> databaseField.getField().fullName()).toIndexableSet().asUnmodifiable()));

                @Override
                public Variant converter(TextRecord input) throws IOException {
                    Coordinate coordinate = liftover.convert(new Coordinate(Chromosome.get(input.get("Chrom").toString()), input.get("Pos_end").toInt()));
                    if (coordinate == null) {
                        return null;
                    }
                    Variant variant = new Variant(coordinate).addAllele(input.get("Ref").toString()).addAllele(input.get("Alts").toString()).setProperty(this.properties.get());
                    for (DatabaseField field : FIELDS) {
                        variant.setProperty(field.getField().fullName(), input.get(field.getSource()));
                    }
                    return variant;
                }
            }).setListener(this.silent ? null : new OutputListener()).submit(threads);
            GTBSorter sorter = GTBSorter.setInput(this.output, new String[0]).setListener(this.silent ? null : new SortListener());
            if (!sorter.isOrdered(threads)) {
                sorter.sort(this.output, threads, false);
            }
            GTBIndexer.setInput(this.output, new String[0]).setListener(this.silent ? null : new InputListener("Indexed", "records")).save(threads);
        }
    }

    public static class InputSetting {
        final LiveFile input;

        private InputSetting(LiveFile input) {
            this.input = input;
        }

        public OutputSetting setOutput(String output) {
            return new OutputSetting(this.input, new File(output));
        }

        public OutputSetting setOutput(File output) {
            return new OutputSetting(this.input, output);
        }
    }
}

