/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.plink;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.LiteTable;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.toolkit.Processor;
import edu.sysu.pmglab.ccf.toolkit.input.TextInputOption;
import edu.sysu.pmglab.ccf.toolkit.output.GTBOutputOption;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.executor.track.ITrack;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.exception.InvalidIndividualException;
import edu.sysu.pmglab.gtb.exception.InvalidPLINKFileException;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.toolkit.plink.BEDReader;
import edu.sysu.pmglab.gtb.toolkit.plink.PLINKFile;
import edu.sysu.pmglab.gtb.toolkit.plink.PLINKReader;
import edu.sysu.pmglab.gtb.toolkit.plink.PLINKType;
import edu.sysu.pmglab.gtb.toolkit.vcf.VCFHeader;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.reader.ISeekableReaderStream;
import edu.sysu.pmglab.io.text.TextRecord;
import edu.sysu.pmglab.io.text.reader.IHeaderParser;
import edu.sysu.pmglab.io.text.reader.IMetadataParser;
import edu.sysu.pmglab.io.text.reader.Separator;
import edu.sysu.pmglab.io.text.reader.TextReader;
import java.io.File;
import java.io.IOException;
import java.util.AbstractCollection;

class BEDFile
extends PLINKFile {
    final IndexableSet<String> UIDs;
    final LiteTable individuals;
    final GTBManager indexer;

    BEDFile(String path) throws IOException {
        super(path, PLINKType.BED);
        if (!(LiveFile.exists(path + ".bed") && LiveFile.exists(path + ".bim") && LiveFile.exists(path + ".fam"))) {
            throw new InvalidPLINKFileException("A full .bed + .bim + .fam fileset is required for this");
        }
        LiveFile bed = LiveFile.of(path + ".bed");
        try (ISeekableReaderStream reader = bed.openAsBinary();){
            byte[] bits = reader.read(3);
            if (bits == null || bits.length < 3 || bits[0] != 108 || bits[1] != 27) {
                throw new InvalidPLINKFileException("Invalid header bytes in .bed file or earlier version");
            }
            if (bits[2] != 1) {
                throw new InvalidPLINKFileException("SNP-major mode requires here");
            }
        }
        var4_5 = null;
        try (TextReader famReader = TextReader.setInput(LiveFile.of(path + ".fam")).setMetadataParser(IMetadataParser.NO_METADATA).setHeaderParser(IHeaderParser.assign(false, true, "FID", "IID", "PAT", "MAT", "SEX", "PHENOTYPE")).setSeparator(Separator.BLANK).instance();){
            LinkedSet UIDs = new LinkedSet();
            LiteTable individuals = new LiteTable().addField("FID", FieldType.string).addField("IID", FieldType.string).addField("PAT", FieldType.string).addField("MAT", FieldType.string).addField("SEX", FieldType.string).addField("PHENOTYPE", FieldType.string);
            TextRecord record = famReader.getRecord();
            while (famReader.read(record)) {
                String FID = record.get("FID").length() == 0 || record.get("FID").valueEquals((byte)48) || record.get("FID").valueEquals((byte)46) ? null : record.get("FID").toString();
                String IID = record.get("IID").toString();
                if (!VCFHeader.isValidIndividual(IID) || IID.equals("0") || IID.equals(".")) {
                    throw new InvalidIndividualException("Invalid PLINK-FAM individual: " + IID);
                }
                String PAT = record.get("PAT").length() == 0 || record.get("PAT").valueEquals((byte)48) || record.get("FID").valueEquals((byte)46) ? null : record.get("PAT").toString();
                String MAT = record.get("MAT").length() == 0 || record.get("MAT").valueEquals((byte)48) || record.get("FID").valueEquals((byte)46) ? null : record.get("MAT").toString();
                String SEX = record.get("SEX").length() == 0 || record.get("SEX").valueEquals((byte)46) ? "0" : record.get("SEX").toString();
                String PHENOTYPE = record.get("PHENOTYPE").toString();
                String UID = FID == null || IID.equals(FID) ? IID : FID + "_" + IID;
                if (((IndexableSet)UIDs).contains(UID)) {
                    throw new InvalidPLINKFileException("Duplicated individual: " + UID);
                }
                ((AbstractCollection)UIDs).add(UID);
                individuals.alloc(FID, IID, PAT, MAT, SEX, PHENOTYPE);
            }
            this.UIDs = UIDs.asUnmodifiable();
            this.individuals = individuals.asUnmodifiable();
        }
        catch (Throwable UIDs) {
            var4_5 = UIDs;
            throw UIDs;
        }
        if ((bed.length() - 3L) % (long)(this.UIDs.size() / 4 + (this.UIDs.size() % 4 == 0 ? 0 : 1)) != 0L) {
            throw new InvalidPLINKFileException("Invalid length in .bed and .fam file");
        }
        long numOfVariants = (bed.length() - 3L) / (long)(this.UIDs.size() / 4 + (this.UIDs.size() % 4 == 0 ? 0 : 1));
        LiveFile bimFile = LiveFile.of(path + ".bim");
        File temp = RuntimeProperty.createFile("plink_bim_" + ITrack.digest(bimFile.getPath(), bimFile.lastModifyTime(), bimFile.length()) + ".cache");
        if (!temp.exists()) {
            Processor.setInput(new TextInputOption(bimFile).setHeaderParser(IHeaderParser.assign(false, true, "CHROM", "SNP", "CM", "POS", "A1", "A2")).setSeparator(Separator.BLANK).setMetadataParser(IMetadataParser.BEGIN_WITH_2_NUMBER_SIGN)).setOutput(new GTBOutputOption(temp).addField(null, "ID", FieldType.string).addField(null, "CM", FieldType.string)).bridge(input -> {
                Variant variant = new Variant(Chromosome.get(input.get("CHROM").toString()), input.get("POS").toInt());
                variant.addAllele(input.get("A1").toString());
                variant.addAllele(input.get("A2").toString());
                if (variant.numOfAlleles() != 2) {
                    throw new InvalidPLINKFileException("Duplicated allele '" + input.get("A2") + "' for variant: " + variant.getCoordinate());
                }
                Bytes SNP = input.get("SNP");
                if (SNP.length() == 0 || SNP.valueEquals((byte)46)) {
                    variant.setProperty("ID", variant.getChromosome() + ":" + variant.getPosition() + "_" + variant.alleleOfIndex(0) + "_" + variant.alleleOfIndex(1));
                } else {
                    variant.setProperty("ID", SNP.toString());
                }
                variant.setProperty("CM", input.get("CM").toString());
                return variant;
            }).submit(2);
        }
        this.indexer = new GTBManager(temp);
        if (this.indexer.numOfVariants() != numOfVariants) {
            throw new InvalidPLINKFileException("Invalid length in .bed and .bim file");
        }
    }

    @Override
    public PLINKReader instance(boolean loadGenotype) throws IOException {
        return new BEDReader(this, loadGenotype);
    }

    @Override
    public IndexableSet<String> getIndividuals() {
        return this.UIDs;
    }

    @Override
    public LiteTable getIndividualInfo() {
        return this.individuals;
    }

    @Override
    public int numOfIndividuals() {
        return this.UIDs.size();
    }

    @Override
    public long numOfVariants() {
        return this.indexer.numOfVariants();
    }

    @Override
    public GTBManager getIndexer() {
        return this.indexer;
    }

    @Override
    public ICCFMeta getMeta() {
        return this.indexer.getMeta();
    }

    @Override
    public IFieldCollection getAllFields() {
        return this.indexer.getAllFields();
    }
}

