/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.plink;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.container.array.IntArray;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.interval.LongInterval;
import edu.sysu.pmglab.gtb.exception.InvalidPLINKFileException;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.genome.genotype.GenotypesType;
import edu.sysu.pmglab.gtb.genome.genotype.container.BEDGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.counter.ArrayCounter;
import edu.sysu.pmglab.gtb.toolkit.plink.PLINKFile;
import edu.sysu.pmglab.gtb.toolkit.plink.PLINKReader;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.reader.ISeekableReaderStream;
import java.io.IOException;

class BEDReader
extends PLINKReader {
    private static final byte[] BED_DECODER_CODE = new byte[]{Genotype.of(0, 0).bytecode(), Genotype.of(-1, -1).bytecode(), Genotype.of(0, 1).bytecode(), Genotype.of(1, 1).bytecode()};
    final ISeekableReaderStream bedReader;
    final int numOfIndividuals;
    final byte[] temp;

    BEDReader(PLINKFile file, boolean loadGenotype) throws IOException {
        super(file, loadGenotype);
        if (loadGenotype) {
            this.bedReader = LiveFile.of(this.file.getFile() + ".bed").openAsBinary();
            this.temp = new byte[this.file.numOfIndividuals() / 4 + (this.file.numOfIndividuals() % 4 == 0 ? 0 : 1)];
        } else {
            this.bedReader = null;
            this.temp = null;
        }
        this.numOfIndividuals = this.file.numOfIndividuals();
    }

    private static BEDGenotypes loadFromBED(int size, byte[] codec) {
        int[] GTs = new int[9];
        int byteIndex = 0;
        int individualIndex = 0;
        for (int genotypeIndex = 0; genotypeIndex < size; ++genotypeIndex) {
            byte b = codec[byteIndex];
            if (individualIndex == 0) {
                byte by = BED_DECODER_CODE[b & 3];
                GTs[by] = GTs[by] + 1;
            } else if (individualIndex == 1) {
                byte by = BED_DECODER_CODE[(b & 0xC) >> 2];
                GTs[by] = GTs[by] + 1;
            } else if (individualIndex == 2) {
                byte by = BED_DECODER_CODE[(b & 0x30) >> 4];
                GTs[by] = GTs[by] + 1;
            } else {
                byte by = BED_DECODER_CODE[(b & 0xC0) >> 6];
                GTs[by] = GTs[by] + 1;
            }
            if (++individualIndex != 4) continue;
            individualIndex = 0;
            ++byteIndex;
        }
        ArrayCounter counter = new ArrayCounter(new IntArray(GTs), size);
        ByteStream cache = ByteStream.getThreadInstance();
        counter.encodeTo(cache);
        cache.write(GenotypesType.PLINK_BED.getMagicCode(false));
        int offset = cache.length();
        cache.write(codec);
        return new BEDGenotypes(false, counter, offset, cache.toBytes(true));
    }

    @Override
    public boolean isPhased() {
        return false;
    }

    @Override
    public IndexableSet<String> getIndividuals() {
        return this.bedReader == null ? IndexableSet.EMPTY() : this.file.getIndividuals();
    }

    @Override
    public Variant read() throws IOException {
        long pointer = this.reader.tell();
        Variant variant = this.reader.read();
        if (variant == null) {
            return null;
        }
        if (this.loadGenotype) {
            this.bedReader.seek(3L + pointer * (long)this.temp.length);
            if (this.bedReader.read(this.temp, 0, this.temp.length) != this.temp.length) {
                throw new InvalidPLINKFileException("Invalid length in .bed and .fam file");
            }
            variant.setGenotypes(BEDReader.loadFromBED(this.numOfIndividuals, this.temp));
        }
        return variant;
    }

    @Override
    public void seek(long pointer) throws IOException {
        this.reader.seek(pointer);
    }

    @Override
    public BEDReader limit(long min, long max) throws IOException {
        this.reader.limit(min, max);
        return this;
    }

    @Override
    public BEDReader limit(LongInterval ranges) throws IOException {
        this.reader.limit(ranges);
        return this;
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.reader.isClosed()) {
            this.reader.close();
            if (this.loadGenotype) {
                this.bedReader.close();
            }
        }
    }
}

