/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.plink;

import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.list.IntList;
import edu.sysu.pmglab.gtb.exception.GTBComponentException;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.genotype.IGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.container.BEDGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.container.ConstantGenotypes;
import edu.sysu.pmglab.gtb.toolkit.plink.PLINKType;
import edu.sysu.pmglab.gtb.toolkit.plink.PLINKWriter;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.reader.ISeekableReaderStream;
import edu.sysu.pmglab.io.text.TextRecord;
import edu.sysu.pmglab.io.text.writer.IHeaderFormatter;
import edu.sysu.pmglab.io.text.writer.Joiner;
import edu.sysu.pmglab.io.text.writer.TextWriter;
import edu.sysu.pmglab.io.writer.ChannelAppendStream;
import edu.sysu.pmglab.io.writer.ChannelWriterStream;
import java.io.File;
import java.io.IOException;

class BEDWriter
extends PLINKWriter {
    final TextWriter bimWriter;
    final TextRecord[] bimRecords;
    final ChannelWriterStream[] bedWriters;
    final File[] genotypeFiles;

    BEDWriter(String file, int nParts, IndexableSet<String> individuals) throws IOException {
        super(file, nParts, PLINKType.BED, individuals);
        this.bimRecords = new TextRecord[nParts];
        this.bedWriters = new ChannelWriterStream[this.nParts];
        this.genotypeFiles = new File[this.nParts];
        this.bimWriter = TextWriter.setOutput(new File(file + ".bim")).addFields("CHROM", "SNP", "CM", "POS", "A1", "A2").setHeaderFormatter(IHeaderFormatter.NO_HEADER_LINE).setValueJoiner(Joiner.TAB).instance(nParts);
        this.bimRecords[0] = new TextRecord(this.bimWriter.keys());
        this.bedWriters[0] = new ChannelWriterStream(new File(file + ".bed"));
        this.bedWriters[0].write(new byte[]{108, 27, 1});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int partIndex, Variant variant) throws IOException {
        String CM;
        String snp;
        IGenotypes genotypes;
        if (this.closed.get()) {
            throw new IllegalStateException("IO Stream closed");
        }
        if (variant == null) {
            return;
        }
        if (variant.numOfAlleles() <= 1) {
            return;
        }
        if (this.bedWriters[partIndex] == null) {
            BEDWriter bEDWriter = this;
            synchronized (bEDWriter) {
                if (this.bedWriters[partIndex] == null) {
                    this.genotypeFiles[partIndex] = new File(this.tempDir, "part" + partIndex);
                    this.genotypeFiles[partIndex].deleteOnExit();
                    this.bedWriters[partIndex] = new ChannelWriterStream(this.genotypeFiles[partIndex]);
                    this.bimRecords[partIndex] = new TextRecord(this.bimRecords[0].keys());
                }
            }
        }
        if ((genotypes = variant.getGenotypes()) == null || genotypes.size() == 0) {
            genotypes = new ConstantGenotypes(this.individuals.size(), null);
        } else if (genotypes.size() != this.individuals.size()) {
            throw new GTBComponentException("Invalid genotypes: " + variant.getCoordinate() + " takes " + this.individuals.size() + " genotypes, but " + genotypes.size() + " given");
        }
        TextRecord record = this.bimRecords[partIndex];
        record.set("CHROM", variant.getChromosome().getName());
        record.set("POS", variant.getPosition());
        if (variant.numOfAlleles() == 2 || genotypes.counter().count(genotype -> genotype.left() >= 2 || genotype.right() >= 2) == 0) {
            record.set("A1", variant.alleleOfIndex(0));
            record.set("A2", variant.alleleOfIndex(1));
        } else {
            int[] ACs = genotypes.counter().getACs();
            if (ACs.length <= 2) {
                record.set("A1", variant.alleleOfIndex(0));
                record.set("A2", variant.alleleOfIndex(1));
            } else {
                IntList indexes = IntList.range(0, ACs.length - 1);
                indexes.sortWith(ACs);
                int a1 = indexes.lastGet(1);
                int a2 = indexes.lastGet(0);
                record.set("A1", variant.alleleOfIndex(a1));
                record.set("A2", variant.alleleOfIndex(a2));
                genotypes = genotypes.toBiallelic(a1, a2, 0);
            }
        }
        String string = snp = variant.getProperty("ID") == null ? "." : variant.getProperty("ID").toString();
        if (snp.length() == 0 || snp.equals(".")) {
            snp = variant.getChromosome() + ":" + variant.getPosition() + "_" + record.get("A1") + "_" + record.get("A2");
        }
        record.set("SNP", snp);
        String string2 = CM = variant.getProperty("CM") == null ? "0" : variant.getProperty("CM").toString();
        if (CM.length() == 0 || CM.equals(".")) {
            CM = "0";
        }
        record.set("CM", CM);
        this.bimWriter.write(partIndex, record);
        this.bedWriters[partIndex].write(BEDGenotypes.load(genotypes).toBED());
        this.counter.addAndGet(1L);
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed.get()) {
            return;
        }
        this.closed.set(true);
        for (int i = 0; i < this.bedWriters.length; ++i) {
            this.finish(i);
        }
        this.bimWriter.close();
        ChannelAppendStream output = new ChannelAppendStream(new File(this.file + ".bed"));
        for (int i = 1; i < this.genotypeFiles.length; ++i) {
            if (this.genotypeFiles[i] == null) continue;
            ISeekableReaderStream reader = LiveFile.of(this.genotypeFiles[i]).openAsBinary();
            reader.transferTo(0L, reader.length(), output);
            reader.close();
            FileUtils.delete(this.genotypeFiles[i]);
        }
        output.close();
        FileUtils.delete(this.tempDir);
    }

    @Override
    public void finish(int partIndex) throws IOException {
        if (this.bedWriters[partIndex] != null) {
            this.bedWriters[partIndex].close();
        }
        this.bimWriter.finish(partIndex);
    }
}

