/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.plink;

import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.container.array.EmptyArray;
import edu.sysu.pmglab.gtb.exception.GTBComponentException;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.genome.genotype.container.PLTypedGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.counter.EmptyCounter;
import edu.sysu.pmglab.gtb.genome.genotype.counter.ICounter;
import gnu.trove.iterator.TIntIterator;
import java.util.NoSuchElementException;

public class PGENCounter
extends ICounter {
    final int[] counter;
    final int total;

    public PGENCounter(int[] counter, int total) {
        int[] nArray;
        if (counter == null || counter.length == 0) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = total;
        } else {
            nArray = counter;
        }
        this.counter = nArray;
        this.total = total;
        if (!PGENCounter.isValidPLCounterSequenceLength(this.counter.length)) {
            throw new GTBComponentException("Validation failed: The inspection did not meet the required PL's standard");
        }
    }

    private static boolean isValidPLCounterSequenceLength(int sequenceLength) {
        if (sequenceLength == 1 || sequenceLength == 2 || sequenceLength == 4 || sequenceLength == 7 || sequenceLength == 11) {
            return true;
        }
        for (int i = 5; i < 4095; ++i) {
            int expectLength = i * (i + 1) / 2 + 1;
            if (expectLength == sequenceLength) {
                return true;
            }
            if (expectLength <= sequenceLength) continue;
            return false;
        }
        return false;
    }

    @Override
    public int count(int code) {
        int pl = PLTypedGenotypes.toPLCode(Genotype.of(code));
        if (pl == -1) {
            return this.counter[this.counter.length - 1];
        }
        if (pl == -2) {
            return 0;
        }
        return this.counter[pl];
    }

    @Override
    public int getAC() {
        if (this.total == 0) {
            return 0;
        }
        int AC = 0;
        int total = this.total;
        for (int i = 0; i < this.counter.length - 1; ++i) {
            int count = this.counter[i];
            if (count <= 0) continue;
            AC += this.indexToGenotype(i).getAC() * count;
            if ((total -= count) == 0) break;
        }
        return AC;
    }

    @Override
    public int getAN() {
        if (this.total == 0) {
            return 0;
        }
        int AN = 0;
        int total = this.total;
        for (int i = 0; i < this.counter.length - 1; ++i) {
            int count = this.counter[i];
            if (count <= 0) continue;
            AN += this.indexToGenotype(i).getAN() * count;
            if ((total -= count) == 0) break;
        }
        return AN;
    }

    @Override
    public float getAF() {
        if (this.total == 0) {
            return Float.NaN;
        }
        int AN = 0;
        int AC = 0;
        int total = this.total;
        for (int i = 0; i < this.counter.length - 1; ++i) {
            int count = this.counter[i];
            if (count <= 0) continue;
            Genotype genotype = this.indexToGenotype(i);
            AC += genotype.getAC() * count;
            AN += genotype.getAN() * count;
            if ((total -= count) == 0) break;
        }
        if (AN == 0) {
            return Float.NaN;
        }
        return (float)AC / (float)AN;
    }

    @Override
    public int getAC(int alleleIndex) {
        if (this.total == 0) {
            return 0;
        }
        int AC = 0;
        int total = this.total;
        for (int i = 0; i < this.counter.length - 1; ++i) {
            int count = this.counter[i];
            if (count <= 0) continue;
            AC += this.indexToGenotype(i).getAC(alleleIndex) * count;
            if ((total -= count) == 0) break;
        }
        if (alleleIndex == -1) {
            AC += 2 * this.counter[this.counter.length - 1];
        }
        return AC;
    }

    @Override
    public int[] getACs() {
        if (this.total == 0) {
            return EmptyArray.INT;
        }
        int maxAlleleIndex = this.maxAlleleIndex();
        if (maxAlleleIndex == -1) {
            return EmptyArray.INT;
        }
        int[] acs = new int[maxAlleleIndex + 1];
        int total = this.total;
        for (int i = 0; i < this.counter.length - 1; ++i) {
            int count = this.counter[i];
            if (count <= 0) continue;
            Genotype genotype = this.indexToGenotype(i);
            if (genotype.left() != -1) {
                int n = genotype.left();
                acs[n] = acs[n] + count;
            }
            if (genotype.right() != -1) {
                int n = genotype.right();
                acs[n] = acs[n] + count;
            }
            if ((total -= count) == 0) break;
        }
        return acs;
    }

    @Override
    public int maxAlleleIndex() {
        if (this.total == 0 || this.counter.length == 1) {
            return -1;
        }
        return this.indexToGenotype(this.counter.length - 2).left();
    }

    @Override
    public Genotype argmax() {
        if (this.total == 0) {
            return Genotype.MISSING;
        }
        int maxCount = 0;
        Genotype maxGenotype = Genotype.MISSING;
        int total = this.total;
        for (int i = 0; i < this.counter.length; ++i) {
            int count = this.counter[i];
            if (count <= 0) continue;
            if (count > maxCount) {
                maxCount = count;
                maxGenotype = this.indexToGenotype(i);
            }
            if ((total -= count) == 0) break;
        }
        return maxGenotype;
    }

    @Override
    public int count(IFilter<Genotype> filter) {
        if (this.total == 0) {
            return 0;
        }
        int sum = 0;
        int total = this.total;
        for (int i = 0; i < this.counter.length; ++i) {
            int count = this.counter[i];
            if (count <= 0) continue;
            if (filter == null || filter.filter(this.indexToGenotype(i))) {
                sum += count;
            }
            if ((total -= count) == 0) break;
        }
        return sum;
    }

    @Override
    public int count() {
        return this.total;
    }

    @Override
    public int size() {
        if (this.total == 0) {
            return 0;
        }
        int size = 0;
        int total = this.total;
        for (int count : this.counter) {
            if (count <= 0) continue;
            ++size;
            if ((total -= count) == 0) break;
        }
        return size;
    }

    @Override
    public TIntIterator codeIterator() {
        if (this.total == 0) {
            return EmptyCounter.INSTANCE().codeIterator();
        }
        return new TIntIterator(){
            int currentIndex = 0;
            int total;
            {
                this.total = PGENCounter.this.total;
            }

            @Override
            public int next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.total -= PGENCounter.this.counter[this.currentIndex];
                if (this.currentIndex == PGENCounter.this.counter.length - 1) {
                    ++this.currentIndex;
                    return 0;
                }
                return PGENCounter.this.indexToGenotype(this.currentIndex++).intcode();
            }

            @Override
            public boolean hasNext() {
                while (this.currentIndex < PGENCounter.this.counter.length && this.total > 0) {
                    if (PGENCounter.this.counter[this.currentIndex] > 0) {
                        return true;
                    }
                    ++this.currentIndex;
                }
                return false;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private Genotype indexToGenotype(int index) {
        if (index == this.counter.length - 1) {
            return Genotype.MISSING;
        }
        return PLTypedGenotypes.toGenotype(index);
    }
}

