/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.plink;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.bytecode.BytesSplitter;
import edu.sysu.pmglab.ccf.LiteTable;
import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.record.IRecord;
import edu.sysu.pmglab.ccf.toolkit.Processor;
import edu.sysu.pmglab.ccf.toolkit.input.TextInputOption;
import edu.sysu.pmglab.ccf.toolkit.output.GTBOutputOption;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.track.ITrack;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.exception.InvalidIndividualException;
import edu.sysu.pmglab.gtb.exception.InvalidPLINKFileException;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.toolkit.plink.PGENReader;
import edu.sysu.pmglab.gtb.toolkit.plink.PLINKFile;
import edu.sysu.pmglab.gtb.toolkit.plink.PLINKReader;
import edu.sysu.pmglab.gtb.toolkit.plink.PLINKType;
import edu.sysu.pmglab.gtb.toolkit.vcf.VCFHeader;
import edu.sysu.pmglab.gtb.toolkit.vcf.VCFWriter;
import edu.sysu.pmglab.gtb.toolkit.vcf.parser.AllINFOParser;
import edu.sysu.pmglab.gtb.toolkit.vcf.parser.VCFFormatParser;
import edu.sysu.pmglab.io.file.FileType;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.text.TextRecord;
import edu.sysu.pmglab.io.text.reader.IHeaderParser;
import edu.sysu.pmglab.io.text.reader.IMetadataParser;
import edu.sysu.pmglab.io.text.reader.Separator;
import edu.sysu.pmglab.io.text.reader.TextReader;
import java.io.File;
import java.io.IOException;
import java.util.AbstractCollection;

class PGENFile
extends PLINKFile {
    final IndexableSet<String> UIDs;
    final LiteTable individuals;
    final GTBManager indexer;

    PGENFile(String path) throws IOException {
        super(path, PLINKType.PGEN);
        if (!(LiveFile.exists(path + ".pgen") && LiveFile.exists(path + ".pvar") && LiveFile.exists(path + ".psam"))) {
            throw new InvalidPLINKFileException("A full .pgen + .pvar + .psam fileset is required for this");
        }
        if (LiveFile.of(path + ".pgen").getFileType() != FileType.LOCAL) {
            throw new InvalidPLINKFileException(".pgen file is accessed via CPython and pgenlib, not the Java API, and therefore require a local file path");
        }
        try (TextReader reader = TextReader.setInput(LiveFile.of(path + ".psam")).setMetadataParser(IMetadataParser.BEGIN_WITH_2_NUMBER_SIGN).setHeaderParser((data, separator, header) -> {
            if (data.startsWith((byte)35)) {
                IHeaderParser.BEGIN_WITH_1_NUMBER_SIGN.parse(data, separator, header);
                if (!header.contains("IID")) {
                    throw new InvalidPLINKFileException("*.psam file requires IID field at least. Refer to https://www.cog-genomics.org/plink/2.0/formats#psam");
                }
                return true;
            }
            List<Bytes> firstLine = separator.accept(data);
            if (firstLine.size() == 0) {
                throw new InvalidPLINKFileException("This *.psam file missing individual ID field (i.e., IID)");
            }
            if (firstLine.size() == 1) {
                header.add("IID");
            } else if (firstLine.size() == 2) {
                header.add("IID");
                header.add("SEX");
            } else if (firstLine.size() == 3) {
                header.add("FID");
                header.add("IID");
                header.add("SEX");
            } else if (firstLine.size() == 4) {
                header.add("FID");
                header.add("IID");
                header.add("SEX");
                header.add("PHENOTYPE");
            } else if (firstLine.size() == 5) {
                header.add("FID");
                header.add("IID");
                header.add("PAT");
                header.add("MAT");
                header.add("SEX");
            } else if (firstLine.size() == 6) {
                header.add("FID");
                header.add("IID");
                header.add("PAT");
                header.add("MAT");
                header.add("SEX");
                header.add("PHENOTYPE");
            } else {
                header.add("FID");
                header.add("IID");
                header.add("PAT");
                header.add("MAT");
                header.add("SEX");
                for (int i = 5; i < firstLine.size(); ++i) {
                    String field = "PHENO" + (i - 4);
                    header.add(field);
                }
            }
            return false;
        }).setSeparator(Separator.BLANK).instance();){
            LinkedSet UIDs = new LinkedSet();
            LiteTable individuals = new LiteTable();
            for (String field : reader.getHeader()) {
                individuals.addField(field, FieldType.string);
            }
            TextRecord record = reader.getRecord();
            while (reader.read(record)) {
                String IID = record.get("IID").toString();
                if (!VCFHeader.isValidIndividual(IID) || IID.equals("0") || IID.equals(".")) {
                    throw new InvalidIndividualException("Invalid PLINK-PSAM individual: " + IID);
                }
                if (((IndexableSet)UIDs).contains(IID)) {
                    throw new InvalidPLINKFileException("Duplicated individual: " + IID);
                }
                ((AbstractCollection)UIDs).add(IID);
                IRecord container = individuals.alloc();
                for (String field : record.keys()) {
                    container.set(field, (Object)record.get(field));
                }
            }
            this.UIDs = UIDs.asUnmodifiable();
            this.individuals = individuals.asUnmodifiable();
        }
        LiveFile pvarFile = LiveFile.of(path + ".pvar");
        File temp = RuntimeProperty.createFile("plink_pvar_" + ITrack.digest(pvarFile.getPath(), pvarFile.lastModifyTime(), pvarFile.length()) + ".cache");
        if (!temp.exists()) {
            FieldGroupMeta fields = new FieldGroupMeta(null);
            Processor.setInput(new TextInputOption(path + ".pvar").setMetadataParser(IMetadataParser.BEGIN_WITH_2_NUMBER_SIGN).setHeaderParser((data, separator, header) -> {
                if (data.startsWith((byte)35)) {
                    IHeaderParser.BEGIN_WITH_1_NUMBER_SIGN.parse(data, separator, header);
                    if (!(header.contains("CHROM") && header.contains("POS") && header.contains("REF") && header.contains("ALT"))) {
                        throw new InvalidPLINKFileException("*.pvar file requires CHROM, POS, REF, ALT fields at least. Refer to https://www.cog-genomics.org/plink/2.0/formats#pvar");
                    }
                    for (String field : header) {
                        if (field.equals("CHROM") || field.equals("POS") || field.equals("ALT") || field.equals("REF")) continue;
                        if (field.equals("INFO")) {
                            fields.addField(FieldMeta.of("INFO", FieldType.stringBytecodeMap));
                            continue;
                        }
                        if (field.equals("FORMAT")) {
                            fields.addField(FieldMeta.of("FORMAT", FieldType.stringIndexableSet));
                            continue;
                        }
                        fields.addField(FieldMeta.of(field, FieldType.string));
                    }
                    return true;
                }
                List<Bytes> firstLine = separator.accept(data);
                if (firstLine.size() == 4) {
                    header.add("CHROM");
                    header.add("POS");
                    header.add("ALT");
                    header.add("REF");
                } else if (firstLine.size() == 5) {
                    header.add("CHROM");
                    header.add("ID");
                    header.add("POS");
                    header.add("ALT");
                    header.add("REF");
                    fields.addField(FieldMeta.of(null, "ID", FieldType.string));
                } else if (firstLine.size() >= 6) {
                    header.add("CHROM");
                    header.add("ID");
                    header.add("CM");
                    header.add("POS");
                    header.add("ALT");
                    header.add("REF");
                    fields.addField(FieldMeta.of(null, "ID", FieldType.string));
                    fields.addField(FieldMeta.of(null, "CM", FieldType.string));
                    for (int i = 6; i < firstLine.size(); ++i) {
                        String field = "V" + (i + 1);
                        header.add(field);
                        fields.addField(FieldMeta.of(null, field, FieldType.string));
                    }
                } else {
                    throw new InvalidPLINKFileException("This *.pvar without a defined header row can only have 5 or 6 columns. Ref to https://www.cog-genomics.org/plink/2.0/formats#pvar");
                }
                return false;
            }).setSeparator(Separator.BLANK)).setOutput(new GTBOutputOption(temp), (inputs, output) -> {
                ((TextInputOption)inputs.fastGet(0)).getAllFields();
                output.addMeta(((TextInputOption)inputs.fastGet(0)).getMeta());
                output.addFields(fields);
            }).bridge(input -> {
                int numOfAlleles = 1;
                Variant variant = new Variant(Chromosome.get(input.get("CHROM").toString()), input.get("POS").toInt());
                variant.addAllele(input.get("REF").toString());
                BytesSplitter alts = new BytesSplitter(44).init(input.get("ALT"));
                while (alts.hasNext()) {
                    ++numOfAlleles;
                    variant.addAllele(alts.next().toString());
                }
                alts.clear();
                if (variant.numOfAlleles() != numOfAlleles) {
                    throw new InvalidPLINKFileException("Variant " + variant.getCoordinate() + " contains duplicated alternative alleles: \n" + input.values().toString("\t"));
                }
                for (FieldMeta field : fields) {
                    if (field.fullName().equals("INFO")) {
                        variant.setProperty("INFO", AllINFOParser.INSTANCE.parse(input.get("INFO")));
                        continue;
                    }
                    if (field.fullName().equals("FORMAT")) {
                        variant.setProperty("FORMAT", VCFFormatParser.parseFormat(input.get("FORMAT")));
                        continue;
                    }
                    variant.setProperty(field.fullName(), input.get(field.simpleName()).toString());
                }
                String ID = (String)variant.getProperty("ID");
                if (ID == null || ID.equals(".")) {
                    variant.setProperty("ID", VCFWriter.ID_TO_ASCII(null, variant));
                }
                return variant;
            }).submit(2);
        }
        this.indexer = new GTBManager(temp);
    }

    @Override
    public PLINKReader instance(boolean loadGenotype) throws IOException {
        return new PGENReader(this, loadGenotype);
    }

    @Override
    public IndexableSet<String> getIndividuals() {
        return this.UIDs;
    }

    @Override
    public LiteTable getIndividualInfo() {
        return this.individuals;
    }

    @Override
    public int numOfIndividuals() {
        return this.UIDs.size();
    }

    @Override
    public long numOfVariants() {
        return this.indexer.numOfVariants();
    }

    @Override
    public GTBManager getIndexer() {
        return this.indexer;
    }

    @Override
    public ICCFMeta getMeta() {
        return this.indexer.getMeta();
    }

    @Override
    public IFieldCollection getAllFields() {
        return this.indexer.getAllFields();
    }
}

