/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.plink;

import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.interval.LongInterval;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.genotype.container.ConstantGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.container.LitePGENGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.container.PGENGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.counter.ICounter;
import edu.sysu.pmglab.gtb.toolkit.plink.PGENCounter;
import edu.sysu.pmglab.gtb.toolkit.plink.PLINKFile;
import edu.sysu.pmglab.gtb.toolkit.plink.PLINKReader;
import edu.sysu.pmglab.pyserve.GlobalPythonInterpreter;
import java.io.IOException;

class PGENReader
extends PLINKReader {
    final GlobalPythonInterpreter interp;
    final boolean phased;
    final PyVariable variable;

    public PGENReader(PLINKFile file, boolean loadGenotype) {
        super(file, loadGenotype);
        this.variable = new PyVariable(this.file.getFile());
        if (loadGenotype) {
            this.interp = new GlobalPythonInterpreter();
            this.phased = this.interp.execAndGet(this.variable.init(file.numOfIndividuals()), this.variable.PHASED, Boolean.class);
        } else {
            this.interp = null;
            this.phased = false;
        }
    }

    @Override
    public boolean isPhased() {
        return this.phased;
    }

    @Override
    public IndexableSet<String> getIndividuals() {
        return this.interp == null ? IndexableSet.EMPTY() : this.file.getIndividuals();
    }

    @Override
    public Variant read() throws IOException {
        long pointer = this.reader.tell();
        Variant variant = this.reader.read();
        if (variant == null) {
            return null;
        }
        if (this.loadGenotype) {
            if (this.phased) {
                variant.setGenotypes(new PGENGenotypes(true, this.interp.execAndGet(this.variable.readAlleles(pointer), this.variable.INT_BUFF, int[].class), null));
            } else {
                int numOfAllele = variant.numOfAlleles();
                PGENCounter counter = new PGENCounter(this.interp.execAndGet(this.variable.count(pointer, numOfAllele), this.variable.GT_COUNTER_OUT, int[].class), this.numOfIndividuals());
                if (((ICounter)counter).size() == 1) {
                    variant.setGenotypes(new ConstantGenotypes(this.numOfIndividuals(), ((ICounter)counter).argmax()));
                } else if (numOfAllele == 2 || ((ICounter)counter).maxAlleleIndex() <= 1) {
                    byte[] returns = this.interp.execAndGet(this.variable.read(pointer), this.variable.BYTE_BUFF, byte[].class);
                    variant.setGenotypes(new LitePGENGenotypes(returns, counter));
                } else {
                    int[] returns = this.interp.execAndGet(this.variable.readAlleles(pointer), this.variable.INT_BUFF, int[].class);
                    variant.setGenotypes(new PGENGenotypes(false, returns, counter));
                }
            }
        }
        return variant;
    }

    @Override
    public void seek(long pointer) throws IOException {
        this.reader.seek(pointer);
    }

    @Override
    public PGENReader limit(long min, long max) throws IOException {
        this.reader.limit(min, max);
        return this;
    }

    @Override
    public PGENReader limit(LongInterval ranges) throws IOException {
        this.reader.limit(ranges);
        return this;
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.reader.isClosed()) {
            this.reader.close();
            if (this.loadGenotype) {
                this.interp.exec(this.variable.close());
                this.interp.close();
            }
        }
    }

    private static class PyVariable {
        final String PATH;
        final String PVAR;
        final String PGEN;
        final String PHASED;
        final String GT_COUNTER;
        final String GT_COUNTER_OUT;
        final String INT_BUFF;
        final String BYTE_BUFF;
        final StringBuilder cache = new StringBuilder();
        int GT_COUNTER_SIZE = 121;
        final String ID = String.valueOf(GlobalPythonInterpreter.next());

        public PyVariable(String path) {
            this.PATH = path;
            this.PVAR = "pgenreader_pvar_" + this.ID;
            this.PGEN = "pgenreader_pgen_" + this.ID;
            this.PHASED = "pgenreader_phased_" + this.ID;
            this.GT_COUNTER = "pgenreader_counter_" + this.ID;
            this.GT_COUNTER_OUT = "pgenreader_counter_out_" + this.ID;
            this.INT_BUFF = "pgenreader_int_buff_" + this.ID;
            this.BYTE_BUFF = "pgenreader_byte_buff_" + this.ID;
        }

        public String readAlleles(long pointer) {
            this.cache.setLength(0);
            this.cache.append(this.PGEN).append(".read_alleles(").append(pointer).append(",").append(this.INT_BUFF).append(")");
            return this.cache.toString();
        }

        public String read(long pointer) {
            this.cache.setLength(0);
            this.cache.append(this.PGEN).append(".read(").append(pointer).append(",").append(this.BYTE_BUFF).append(")");
            return this.cache.toString();
        }

        public String count(long pointer, int numOfAllele) {
            int countSize = 1 + numOfAllele * (numOfAllele + 1) / 2;
            this.cache.setLength(0);
            if (countSize > this.GT_COUNTER_SIZE) {
                this.cache.append(this.GT_COUNTER).append("=").append(this.GT_COUNTER).append(" if len(").append(this.GT_COUNTER).append(")>=").append(countSize).append(" else np.zeros(").append(countSize).append(",np.uint32)\n");
                this.GT_COUNTER_SIZE = countSize;
            }
            this.cache.append(this.PGEN).append(".count(").append(pointer).append(",").append(this.GT_COUNTER).append(",allele_idx=None)\n");
            this.cache.append(this.GT_COUNTER_OUT).append("=list(").append(this.GT_COUNTER).append("[:").append(countSize).append("])");
            return this.cache.toString();
        }

        public String init(int size) {
            this.cache.setLength(0);
            this.cache.append("import pgenlib\nimport numpy as np\n");
            this.cache.append(this.PVAR).append("=pgenlib.PvarReader('").append(this.PATH).append(".pvar'.encode('utf-8'))\n");
            this.cache.append(this.PGEN).append("=pgenlib.PgenReader('").append(this.PATH).append(".pgen'.encode('utf-8'),pvar=").append(this.PVAR).append(",raw_sample_ct=").append(size).append(")\n");
            this.cache.append(this.PHASED).append("=").append(this.PGEN).append(".hardcall_phase_present()\n");
            this.cache.append(this.GT_COUNTER).append("=np.zeros(121,np.uint32)\n");
            this.cache.append(this.INT_BUFF).append("=np.empty(").append(this.PGEN).append(".get_raw_sample_ct()*2,np.int32)\n");
            this.cache.append(this.BYTE_BUFF).append("=np.empty(").append(this.PGEN).append(".get_raw_sample_ct(),np.int8)");
            return this.cache.toString();
        }

        public String close() {
            this.cache.setLength(0);
            this.cache.append(this.PGEN).append(".close()\n");
            this.cache.append(this.PVAR).append(".close()");
            return this.cache.toString();
        }
    }
}

