/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.plink;

import com.github.luben.zstd.ZstdOutputStream;
import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.gtb.exception.GTBComponentException;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.genome.genotype.IGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.container.ConstantGenotypes;
import edu.sysu.pmglab.gtb.toolkit.plink.PLINKType;
import edu.sysu.pmglab.gtb.toolkit.plink.PLINKWriter;
import edu.sysu.pmglab.gtb.toolkit.vcf.VCFWriter;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.io.writer.ChannelWriterStream;
import edu.sysu.pmglab.pyserve.GlobalPythonInterpreter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;

class PGENWriter
extends PLINKWriter {
    final VCFWriter pvarWriter;
    final ZstdOutputStream[] pgenWriters;
    final File[] genotypeFiles;
    final AtomicBoolean anyPhased = new AtomicBoolean(false);

    PGENWriter(String file, int nParts, IndexableSet<String> individuals, ICCFMeta meta) throws IOException {
        super(file, nParts, PLINKType.PGEN, individuals);
        this.pgenWriters = new ZstdOutputStream[nParts];
        this.genotypeFiles = new File[nParts];
        this.pvarWriter = VCFWriter.setOutput(new File(file + ".pvar")).addMeta(meta).instance(nParts);
    }

    private static void encodeTo(IGenotypes genotypes, int numOfAllele, ByteStream reused) {
        boolean phased = genotypes.isPhased();
        if (numOfAllele == 0) {
            reused.wRequire(genotypes.size() + 2);
            byte[] codes = reused.bytes();
            int pointer = 0;
            codes[pointer++] = (byte)(genotypes.isPhased() ? 1 : 0);
            codes[pointer++] = (byte)numOfAllele;
            int l = genotypes.size();
            for (int i = 0; i < l; ++i) {
                codes[pointer++] = 0;
            }
            reused.wSeek(genotypes.size() + 2);
        } else if (!phased && numOfAllele <= 2) {
            reused.wRequire(genotypes.size() + 2);
            byte[] codes = reused.bytes();
            int pointer = 0;
            codes[pointer++] = (byte)(genotypes.isPhased() ? 1 : 0);
            codes[pointer++] = (byte)numOfAllele;
            for (Genotype genotype : genotypes) {
                if (genotype.getAN() == 2) {
                    codes[pointer++] = (byte)genotype.getAC();
                    continue;
                }
                codes[pointer++] = 3;
            }
            reused.wSeek(genotypes.size() + 2);
        } else {
            reused.wRequire(genotypes.size() * 2 + 2);
            byte[] codes = reused.bytes();
            int pointer = 0;
            codes[pointer++] = (byte)(genotypes.isPhased() ? 1 : 0);
            codes[pointer++] = (byte)numOfAllele;
            for (Genotype genotype : genotypes) {
                if (genotype.getAN() != 2) {
                    genotype = Genotype.MISSING;
                }
                codes[pointer++] = (byte)genotype.left();
                codes[pointer++] = (byte)genotype.right();
            }
            reused.wSeek(genotypes.size() * 2 + 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int partIndex, Variant variant) throws IOException {
        IGenotypes genotypes;
        if (this.closed.get()) {
            throw new IllegalStateException("IO Stream closed");
        }
        if (variant == null) {
            return;
        }
        if (variant.numOfAlleles() <= 1) {
            return;
        }
        if (this.pgenWriters[partIndex] == null) {
            PGENWriter pGENWriter = this;
            synchronized (pGENWriter) {
                this.genotypeFiles[partIndex] = new File(this.tempDir, "part" + (partIndex + 1));
                this.genotypeFiles[partIndex].deleteOnExit();
                this.pgenWriters[partIndex] = new ZstdOutputStream((OutputStream)new ChannelWriterStream(this.genotypeFiles[partIndex]), 4);
            }
        }
        if ((genotypes = variant.getGenotypes()) == null || genotypes.size() == 0) {
            genotypes = new ConstantGenotypes(this.individuals.size(), null);
        } else if (genotypes.size() != this.individuals.size()) {
            throw new GTBComponentException("Invalid genotypes: " + variant.getCoordinate() + " takes " + this.individuals.size() + " genotypes, but " + genotypes.size() + " given");
        }
        if (genotypes.isPhased() && !this.anyPhased.get()) {
            this.anyPhased.set(true);
        }
        variant.setProperty("ID", VCFWriter.ID_TO_ASCII(variant.getProperty("ID"), variant));
        this.pvarWriter.write(partIndex, variant);
        ByteStream container = ByteStream.getThreadInstance();
        PGENWriter.encodeTo(genotypes, variant.numOfAlleles(), container);
        this.pgenWriters[partIndex].write(container.bytes(), container.offset(), container.length());
        this.counter.addAndGet(1L);
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed.get()) {
            return;
        }
        this.closed.set(true);
        for (int i = 0; i < this.pgenWriters.length; ++i) {
            this.finish(i);
        }
        this.pvarWriter.close();
        String ID = String.valueOf(GlobalPythonInterpreter.next());
        GlobalPythonInterpreter interpreter = new GlobalPythonInterpreter();
        interpreter.exec("import numpy as np\nimport zstandard as zstd\nimport pgenlib\npgenwriter_pgen_" + ID + " = pgenlib.PgenWriter(\"" + this.file + ".pgen\".encode(\"utf-8\"),\n    sample_ct=" + this.individuals.size() + ", variant_ct=" + this.counter.get() + ", allele_ct_limit=255, hardcall_phase_present=" + (this.anyPhased.get() ? "True" : "False") + ")");
        for (File genotypeFile : this.genotypeFiles) {
            if (genotypeFile == null) continue;
            interpreter.exec("pgenwriter_dctx_" + ID + " = zstd.ZstdDecompressor()\nwith open(\"" + genotypeFile + "\",\"rb\") as compressed_file:\n    with pgenwriter_dctx_" + ID + ".stream_reader(compressed_file) as reader:\n        while True:\n            chunk = reader.read(2)\n            if not chunk:\n                break\n            phased = (chunk[0] & 0xFF) == 1\n            allele = chunk[1] & 0xFF\n            if not phased and allele <= 2:\n                chunk = reader.read(" + this.individuals.size() + ")\n                genotypes = np.frombuffer(chunk, dtype=np.int8)\n                pgenwriter_pgen_" + ID + ".append_biallelic(genotypes)\n            else:\n                chunk = reader.read(" + this.individuals.size() * 2 + ")\n                genotypes = np.frombuffer(chunk, dtype=np.uint8).astype(np.int32)\n                genotypes[genotypes == 255] = -9\n                pgenwriter_pgen_" + ID + ".append_alleles(genotypes, all_phased=phased, allele_ct=allele)");
            FileUtils.delete(genotypeFile);
        }
        FileUtils.delete(this.tempDir);
        interpreter.exec("pgenwriter_pgen_" + ID + ".close()");
        interpreter.close();
    }

    @Override
    public void finish(int partIndex) throws IOException {
        if (this.pgenWriters[partIndex] != null) {
            this.pgenWriters[partIndex].close();
            this.pvarWriter.finish(partIndex);
        }
    }
}

