/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.plink;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.LiteTable;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.exception.InvalidIndividualException;
import edu.sysu.pmglab.gtb.exception.InvalidPLINKFileException;
import edu.sysu.pmglab.gtb.toolkit.plink.BEDFile;
import edu.sysu.pmglab.gtb.toolkit.plink.PGENFile;
import edu.sysu.pmglab.gtb.toolkit.plink.PLINKReader;
import edu.sysu.pmglab.gtb.toolkit.plink.PLINKType;
import edu.sysu.pmglab.gtb.toolkit.vcf.VCFHeader;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.text.TextRecord;
import edu.sysu.pmglab.io.text.reader.IHeaderParser;
import edu.sysu.pmglab.io.text.reader.IMetadataParser;
import edu.sysu.pmglab.io.text.reader.Separator;
import edu.sysu.pmglab.io.text.reader.TextReader;
import java.io.IOException;
import java.util.AbstractCollection;

public abstract class PLINKFile {
    final String path;
    final PLINKType type;

    PLINKFile(String path, PLINKType type) {
        this.path = path;
        this.type = type;
    }

    public static PLINKFile load(String path, PLINKType type) throws IOException {
        if (type == PLINKType.BED) {
            return new BEDFile(path);
        }
        if (type == PLINKType.PGEN) {
            return new PGENFile(path);
        }
        throw new InvalidPLINKFileException("Unknown plink binary genotype format: " + (Object)((Object)type));
    }

    public static IndexableSet<String> getIndividuals(String path, PLINKType type) throws IOException {
        if (type == PLINKType.BED) {
            try (TextReader famReader = TextReader.setInput(LiveFile.of(path + ".fam")).setMetadataParser(IMetadataParser.NO_METADATA).setHeaderParser(IHeaderParser.assign(false, true, "FID", "IID", "PAT", "MAT", "SEX", "PHENOTYPE")).setSeparator(Separator.BLANK).instance();){
                IndexableSet<String> FID;
                LinkedSet UIDs = new LinkedSet();
                TextRecord record = famReader.getRecord();
                while (famReader.read(record)) {
                    FID = record.get("FID").length() == 0 || record.get("FID").valueEquals((byte)48) || record.get("FID").valueEquals((byte)46) ? null : record.get("FID").toString();
                    String IID = record.get("IID").toString();
                    if (!VCFHeader.isValidIndividual(IID) || IID.equals("0") || IID.equals(".")) {
                        throw new InvalidIndividualException("Invalid PLINK-FAM individual: " + IID);
                    }
                    String UID = FID == null || IID.equals(FID) ? IID : FID + "_" + IID;
                    if (((IndexableSet)UIDs).contains(UID)) {
                        throw new InvalidPLINKFileException("Duplicated individual: " + UID);
                    }
                    ((AbstractCollection)UIDs).add(UID);
                }
                FID = UIDs.asUnmodifiable();
                return FID;
            }
        }
        if (type == PLINKType.PGEN) {
            try (TextReader reader = TextReader.setInput(LiveFile.of(path + ".psam")).setMetadataParser(IMetadataParser.BEGIN_WITH_2_NUMBER_SIGN).setHeaderParser((data, separator, header) -> {
                if (data.startsWith((byte)35)) {
                    IHeaderParser.BEGIN_WITH_1_NUMBER_SIGN.parse(data, separator, header);
                    if (!header.contains("IID")) {
                        throw new InvalidPLINKFileException("*.psam file requires IID field at least. Refer to https://www.cog-genomics.org/plink/2.0/formats#psam");
                    }
                    return true;
                }
                List<Bytes> firstLine = separator.accept(data);
                if (firstLine.size() == 0) {
                    throw new InvalidPLINKFileException("This *.psam file missing individual ID field (i.e., IID)");
                }
                if (firstLine.size() == 1) {
                    header.add("IID");
                } else if (firstLine.size() == 2) {
                    header.add("IID");
                    header.add("SEX");
                } else if (firstLine.size() == 3) {
                    header.add("FID");
                    header.add("IID");
                    header.add("SEX");
                } else if (firstLine.size() == 4) {
                    header.add("FID");
                    header.add("IID");
                    header.add("SEX");
                    header.add("PHENOTYPE");
                } else if (firstLine.size() == 5) {
                    header.add("FID");
                    header.add("IID");
                    header.add("PAT");
                    header.add("MAT");
                    header.add("SEX");
                } else if (firstLine.size() == 6) {
                    header.add("FID");
                    header.add("IID");
                    header.add("PAT");
                    header.add("MAT");
                    header.add("SEX");
                    header.add("PHENOTYPE");
                } else {
                    header.add("FID");
                    header.add("IID");
                    header.add("PAT");
                    header.add("MAT");
                    header.add("SEX");
                    for (int i = 5; i < firstLine.size(); ++i) {
                        String field = "PHENO" + (i - 4);
                        header.add(field);
                    }
                }
                return false;
            }).setSeparator(Separator.BLANK).instance();){
                LinkedSet UIDs = new LinkedSet();
                TextRecord record = reader.getRecord();
                while (reader.read(record)) {
                    String IID = record.get("IID").toString();
                    if (!VCFHeader.isValidIndividual(IID) || IID.equals("0") || IID.equals(".")) {
                        throw new InvalidIndividualException("Invalid PLINK-PSAM individual: " + IID);
                    }
                    if (((IndexableSet)UIDs).contains(IID)) {
                        throw new InvalidPLINKFileException("Duplicated individual: " + IID);
                    }
                    ((AbstractCollection)UIDs).add(IID);
                }
                IndexableSet<String> indexableSet = UIDs.asUnmodifiable();
                return indexableSet;
            }
        }
        throw new InvalidPLINKFileException("Unknown plink binary genotype format: " + (Object)((Object)type));
    }

    public final String getFile() {
        return this.path;
    }

    public final PLINKType getType() {
        return this.type;
    }

    public final PLINKReader instance() throws IOException {
        return this.instance(true);
    }

    public abstract PLINKReader instance(boolean var1) throws IOException;

    public abstract IndexableSet<String> getIndividuals();

    public abstract LiteTable getIndividualInfo();

    public abstract int numOfIndividuals();

    public abstract long numOfVariants();

    public abstract GTBManager getIndexer();

    public abstract ICCFMeta getMeta();

    public abstract IFieldCollection getAllFields();
}

