/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.plink;

import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.interval.LongInterval;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.GTBReader;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.toolkit.plink.PLINKFile;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class PLINKReader
implements Closeable,
AutoCloseable,
Iterable<Variant> {
    final PLINKFile file;
    final GTBReader reader;
    final boolean loadGenotype;

    PLINKReader(PLINKFile file, boolean loadGenotype) {
        this.file = file;
        this.reader = new GTBReader(this.file.getIndexer());
        this.loadGenotype = loadGenotype;
    }

    public final PLINKFile getFile() {
        return this.file;
    }

    public abstract boolean isPhased();

    public abstract IndexableSet<String> getIndividuals();

    public final int numOfIndividuals() {
        return this.getIndividuals().size();
    }

    public abstract Variant read() throws IOException;

    public abstract void seek(long var1) throws IOException;

    public final long tell() {
        return this.reader.tell();
    }

    public final PLINKReader clearLimit() {
        this.reader.clearLimit();
        return this;
    }

    public abstract PLINKReader limit(long var1, long var3) throws IOException;

    public abstract PLINKReader limit(LongInterval var1) throws IOException;

    public final boolean isClose() {
        return this.reader.isClosed();
    }

    @Override
    public abstract void close() throws IOException;

    public final boolean isClosed() {
        return this.reader.isClosed();
    }

    public final long remaining() {
        return this.reader.remaining();
    }

    public final long numOfVariants() {
        return this.reader.numOfVariants();
    }

    public final LongInterval available() {
        return this.reader.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<PLINKReader> part(int nParts) throws IOException {
        if (this.reader.isClosed()) {
            throw new IOException("IO Stream closed");
        }
        try {
            if (this.remaining() <= 1L || nParts == 1) {
                List<PLINKReader> readers = new List<PLINKReader>(1);
                PLINKReader reader = this.file.instance(this.loadGenotype);
                reader.limit(this.reader.available());
                reader.seek(this.reader.tell());
                readers.add(reader);
                List<PLINKReader> list = readers;
                return list;
            }
            nParts = Math.max(1, nParts);
            LongInterval available = this.reader.available().getOverlaps(new LongInterval(this.reader.tell(), Long.MAX_VALUE));
            List<LongInterval> marks = available.divide(nParts, false);
            GTBReader coors = new GTBReader(new GTBReaderOption(this.reader.getManager(), false, false)).limit(available);
            for (int i = 0; i < marks.size(); ++i) {
                long end;
                long start;
                LongInterval mark = marks.fastGet(i);
                if (i == 0) {
                    start = mark.start();
                    end = mark.end();
                } else {
                    start = marks.fastGet(i - 1).end();
                    end = Math.max(mark.end(), start + 1L);
                }
                coors.seek(end);
                coors.reads();
                end = coors.tell();
                if (start == end && i >= 1) {
                    marks.popLast(marks.size() - i, false);
                    break;
                }
                marks.set(i, new LongInterval(start, end));
            }
            coors.close();
            List<PLINKReader> readers = new List<PLINKReader>(marks.size());
            for (int i = 0; i < marks.size(); ++i) {
                LongInterval mark = marks.fastGet(i);
                PLINKReader reader = this.file.instance(this.loadGenotype);
                reader.limit(mark);
                reader.seek(this.reader.tell());
                readers.add(reader);
            }
            List<PLINKReader> list = readers;
            return list;
        }
        finally {
            this.close();
        }
    }

    @Override
    public Iterator<Variant> iterator() {
        return new Iterator<Variant>(){
            Variant variant;

            @Override
            public boolean hasNext() {
                try {
                    if (this.variant != null) {
                        return true;
                    }
                    this.variant = PLINKReader.this.read();
                    return this.variant != null;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public Variant next() {
                if (this.variant != null) {
                    try {
                        Variant variant = this.variant;
                        return variant;
                    }
                    finally {
                        this.variant = null;
                    }
                }
                try {
                    this.variant = PLINKReader.this.read();
                    if (this.variant != null) {
                        return this.variant;
                    }
                    throw new NoSuchElementException();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

