/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.plink;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.ccf.meta.CCFMeta;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.gtb.exception.InvalidIndividualException;
import edu.sysu.pmglab.gtb.exception.InvalidPLINKFileException;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.toolkit.plink.BEDWriter;
import edu.sysu.pmglab.gtb.toolkit.plink.PGENWriter;
import edu.sysu.pmglab.gtb.toolkit.plink.PLINKType;
import edu.sysu.pmglab.gtb.toolkit.vcf.VCFHeader;
import edu.sysu.pmglab.io.text.TextRecord;
import edu.sysu.pmglab.io.text.writer.IHeaderFormatter;
import edu.sysu.pmglab.io.text.writer.Joiner;
import edu.sysu.pmglab.io.text.writer.TextWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public abstract class PLINKWriter
implements Closeable,
AutoCloseable {
    final File tempDir;
    final String file;
    final IndexableSet<String> individuals;
    final AtomicBoolean closed = new AtomicBoolean(false);
    final PLINKType type;
    final AtomicLong counter = new AtomicLong();
    final int nParts;

    PLINKWriter(String file, int nParts, PLINKType type, IndexableSet<String> individuals) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Null output file");
        }
        if (individuals == null || individuals.size() == 0) {
            throw new UnsupportedOperationException("According to PLINK file format specification, the file should contain at least 1 individual");
        }
        this.type = type;
        this.file = file;
        this.tempDir = RuntimeProperty.createTempDir();
        this.nParts = Math.max(1, nParts);
        this.individuals = new LinkedSet<String>(individuals).asUnmodifiable();
    }

    public static Builder setOutput(String path, PLINKType type) {
        return new Builder(path, type == null ? PLINKType.PGEN : type);
    }

    public final PLINKType getType() {
        return this.type;
    }

    public final int numOfParts() {
        return this.nParts;
    }

    public final IndexableSet<String> getIndividuals() {
        return this.individuals;
    }

    public final String getFile() {
        return this.file;
    }

    public final int numOfIndividuals() {
        return this.individuals.size();
    }

    public final long numOfVariants() {
        return this.counter.get();
    }

    public final void write(Variant variant) throws IOException {
        this.write(0, variant);
    }

    public abstract void write(int var1, Variant var2) throws IOException;

    @Override
    public abstract void close() throws IOException;

    public abstract void finish(int var1) throws IOException;

    public boolean isClosed() {
        return this.closed.get();
    }

    public static class Builder {
        final String file;
        final PLINKType type;
        final IndexableSet<String> individuals = new LinkedSet<String>();
        final ICCFMeta meta = new CCFMeta();

        private Builder(String file, PLINKType type) {
            this.file = file;
            this.type = type;
        }

        public IndexableSet<String> getIndividuals() {
            return this.individuals.asUnmodifiable();
        }

        public Builder setIndividuals(Iterable<String> individuals) {
            this.individuals.clear();
            if (individuals != null) {
                for (String individual : individuals) {
                    if (!VCFHeader.isValidIndividual(individual)) {
                        throw new InvalidIndividualException("Invalid individual: " + individual);
                    }
                    this.individuals.add(individual);
                }
            }
            return this;
        }

        public String getIndividual(int index) {
            return this.individuals.valueOf(index);
        }

        public int indexOfIndividual(String individual) {
            return this.individuals.indexOf(individual);
        }

        public boolean containsIndividual(String individual) {
            return this.individuals.contains(individual);
        }

        public int numOfIndividuals() {
            return this.individuals.size();
        }

        public Builder addIndividual(String individual) {
            if (!VCFHeader.isValidIndividual(individual)) {
                throw new InvalidIndividualException("Invalid individual: " + individual);
            }
            this.individuals.add(individual);
            return this;
        }

        public Builder addIndividuals(String ... individuals) {
            if (individuals != null) {
                for (String individual : individuals) {
                    if (!VCFHeader.isValidIndividual(individual)) {
                        throw new InvalidIndividualException("Invalid individual: " + individual);
                    }
                    this.individuals.add(individual);
                }
            }
            return this;
        }

        public Builder addIndividuals(Iterable<String> individuals) {
            if (individuals != null) {
                for (String individual : individuals) {
                    if (!VCFHeader.isValidIndividual(individual)) {
                        throw new InvalidIndividualException("Invalid individual: " + individual);
                    }
                    this.individuals.add(individual);
                }
            }
            return this;
        }

        public Builder clearIndividuals() {
            this.individuals.clear();
            return this;
        }

        public ICCFMeta getMeta() {
            return this.meta.asUnmodifiable();
        }

        public Builder addMeta(CCFMetaItem meta) {
            this.meta.add(meta);
            return this;
        }

        public Builder addMeta(String key) {
            this.meta.add(key);
            return this;
        }

        public Builder addMeta(String key, String value) {
            this.meta.add(key, value);
            return this;
        }

        public Builder addMeta(Iterable<CCFMetaItem> metas) {
            this.meta.adds(metas);
            return this;
        }

        public Builder clearMetas() {
            this.meta.clear();
            return this;
        }

        public Builder dropDuplicateMetas() {
            this.meta.dropDuplicates();
            return this;
        }

        public String getFile() {
            return this.file;
        }

        public PLINKType getType() {
            return this.type;
        }

        public PLINKWriter instance() throws IOException {
            return this.instance(1);
        }

        public PLINKWriter instance(int nParts) throws IOException {
            if (this.type == PLINKType.BED) {
                try (TextWriter writer = TextWriter.setOutput(this.file + ".fam").setHeaderFormatter(IHeaderFormatter.NO_HEADER_LINE).setValueJoiner(Joiner.TAB).addFields("FID", "IID", "PAT", "MAT", "SEX", "PHENOTYPE").instance();){
                    TextRecord record = writer.getRecord();
                    for (String UID : this.individuals) {
                        record.set("FID", UID);
                        record.set("IID", UID);
                        record.set("PAT", "0");
                        record.set("MAT", "0");
                        record.set("SEX", "0");
                        record.set("PHENOTYPE", "-9");
                        writer.write(record);
                    }
                }
                return new BEDWriter(this.file, nParts, this.individuals);
            }
            if (this.type == PLINKType.PGEN) {
                try (TextWriter writer = TextWriter.setOutput(this.file + ".psam").setHeaderFormatter(IHeaderFormatter.BEGIN_WITH_1_NUMBER_SIGN).setValueJoiner(Joiner.TAB).addFields("IID", "SEX").instance();){
                    TextRecord record = writer.getRecord();
                    for (String UID : this.individuals) {
                        record.set("IID", UID);
                        record.set("SEX", "NA");
                        writer.write(record);
                    }
                }
                return new PGENWriter(this.file, nParts, this.individuals, this.meta);
            }
            throw new InvalidPLINKFileException("Unknown plink binary genotype format: " + (Object)((Object)this.type));
        }
    }
}

