/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.rs;

import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.genome.coordinate.Coordinate;
import edu.sysu.pmglab.gtb.toolkit.rs.IBean;

public class CoordinateBean
extends IBean {
    Coordinate coordinate;

    public CoordinateBean(String coordinate) {
        super(coordinate);
        int index = this.bean.indexOf(":");
        if (index == -1) {
            throw new IllegalArgumentException("Expected format: chr:pos (" + coordinate + " given)");
        }
        Chromosome chromosome = Chromosome.get(this.bean.substring(0, index));
        try {
            int position = Integer.parseInt(this.bean.substring(index + 1));
            this.coordinate = new Coordinate(chromosome, position);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Expected format: chr:pos (" + coordinate + " given)");
        }
    }

    public CoordinateBean(Chromosome chromosome, int pos) {
        super(chromosome + ":" + pos);
        this.coordinate = new Coordinate(chromosome, pos);
    }

    public CoordinateBean(String chromosome, int pos) {
        super(chromosome + ":" + pos);
        this.coordinate = new Coordinate(chromosome, pos);
    }

    public Coordinate getCoordinate() {
        return this.coordinate;
    }
}

