/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.rs;

import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.toolkit.rs.BeanStatus;
import edu.sysu.pmglab.gtb.toolkit.rs.CoordinateBean;
import edu.sysu.pmglab.gtb.toolkit.rs.LocusBean;
import edu.sysu.pmglab.gtb.toolkit.rs.RSBean;

public abstract class IBean {
    final String bean;
    volatile BeanStatus status = BeanStatus.NOT_SUBMITTED;
    volatile Variant result;

    public IBean(String bean) {
        this.bean = bean;
    }

    public static IBean instanceOf(String bean) {
        if ((bean = bean.trim().replaceAll("\\s+", " ")).contains(" ")) {
            String[] parts = bean.split(" ");
            if (parts.length == 2 || parts.length == 3 && (parts[2].length() == 0 || parts[2].equals(".")) || parts.length == 4 && (parts[2].length() == 0 || parts[2].equals(".")) && (parts[3].length() == 0 || parts[3].equals("."))) {
                return new CoordinateBean(Chromosome.get(parts[0]), Integer.parseInt(parts[1]));
            }
            if (parts.length == 3) {
                return new LocusBean(new Variant(Chromosome.get(parts[0]), Integer.parseInt(parts[1])).addAlleles(parts[2].split(",")));
            }
            if (parts.length == 4) {
                return new LocusBean(new Variant(Chromosome.get(parts[0]), Integer.parseInt(parts[1])).addAllele(parts[2]).addAlleles(parts[3].split(",")));
            }
            throw new IllegalArgumentException("Expected format: 'CHROM POS', 'CHROM POS ALLELE' or 'CHROM POS REF ALT' (" + bean + " given)");
        }
        if (bean.contains(":")) {
            if (bean.contains("_")) {
                return new LocusBean(bean);
            }
            return new CoordinateBean(bean);
        }
        return new RSBean(bean);
    }

    public static CoordinateBean instanceOf(String chromosome, int position) {
        return new CoordinateBean(chromosome, position);
    }

    public static CoordinateBean instanceOf(Chromosome chromosome, int position) {
        return new CoordinateBean(chromosome, position);
    }

    public static LocusBean instanceOf(String chromosome, int position, String ref, String alt, String ... alts) {
        return new LocusBean(chromosome, position, ref, alt, alts);
    }

    public static LocusBean instanceOf(Chromosome chromosome, int position, String ref, String alt, String ... alts) {
        return new LocusBean(chromosome, position, ref, alt, alts);
    }

    public static RSBean instanceOf(long rsID) {
        return new RSBean(rsID);
    }

    public final Variant result() {
        if (this.status == BeanStatus.NOT_SUBMITTED || this.status == BeanStatus.NOT_FOUND) {
            return null;
        }
        return this.result;
    }

    public final BeanStatus status() {
        return this.status;
    }

    final synchronized void invoke(BeanStatus status) {
        if (this.status != BeanStatus.NOT_SUBMITTED) {
            throw new IllegalStateException();
        }
        this.status = status;
    }

    public final String toString() {
        return this.bean;
    }
}

