/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.rs;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.toolkit.rs.IBean;

public class LocusBean
extends IBean {
    final Variant query;

    public LocusBean(String locus) {
        super(locus);
        int index = this.bean.indexOf(":");
        if (index == -1) {
            throw new IllegalArgumentException("Expected format: chr:pos_ref_alt1_alt2_... (" + locus + " given)");
        }
        Chromosome chromosome = Chromosome.get(this.bean.substring(0, index));
        String[] subparts = this.bean.substring(index + 1).split("_");
        try {
            if (subparts.length <= 2) {
                throw new IllegalArgumentException("Expected format: chr:pos_ref_alt1_alt2_... (" + locus + " given)");
            }
            int position = Integer.parseInt(subparts[0]);
            this.query = new Variant(chromosome, position);
            for (int altIndex = 1; altIndex < subparts.length; ++altIndex) {
                String allele = subparts[altIndex];
                this.query.addAllele(subparts[altIndex]);
            }
            if (this.query.numOfAlleles() <= 1) {
                throw new IllegalArgumentException("Expected at least 2 alternative alleles, but " + (subparts.length - 1) + " given");
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Expected format: chr:pos_ref_alt1_alt2_... (" + locus + " given)");
        }
    }

    public LocusBean(String chromosome, int position, String ref, String alt, String ... alts) {
        this(Chromosome.get(chromosome), position, ref, alt, alts);
    }

    public LocusBean(Variant variant) {
        super(LocusBean.standardBean(variant));
        this.query = new Variant(variant.getCoordinate()).addAlleles(variant.getAlleles());
        if (this.query.numOfAlleles() <= 1) {
            throw new IllegalArgumentException("Expected at least 2 alternative alleles");
        }
    }

    public LocusBean(Chromosome chromosome, int position, String ref, String alt, String ... alts) {
        super(LocusBean.standardBean(chromosome, position, ref, alt, alts));
        this.query = new Variant(chromosome, position).addAllele(ref).addAllele(alt).addAlleles(alts);
        if (this.query.numOfAlleles() <= 1) {
            throw new IllegalArgumentException("Expected at least 2 alternative alleles");
        }
    }

    static String standardBean(Chromosome chromosome, int position, String ref, String alt, String ... alts) {
        ByteStream container = new ByteStream();
        container.writeChar(chromosome.toString());
        container.write(58);
        container.writeChar(position);
        container.write(95);
        container.writeChar(ref);
        container.write(95);
        container.writeChar(alt);
        for (String allele : alts) {
            container.write(95);
            container.writeChar(allele);
        }
        return container.toString();
    }

    static String standardBean(Variant variant) {
        ByteStream container = new ByteStream();
        container.writeChar(variant.getChromosome().toString());
        container.write(58);
        container.writeChar(variant.getPosition());
        container.write(95);
        container.writeChar(variant.alleleOfIndex(0));
        container.write(95);
        container.writeChar(variant.alleleOfIndex(1));
        for (String allele : variant.getAlleles()) {
            container.write(95);
            container.writeChar(allele);
        }
        return container.toString();
    }

    public Variant getVariant() {
        return this.query;
    }
}

