/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.vcf;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.container.bits.LongBits;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.genome.genotype.IGenotypes;

class TextGenotypesFormatter {
    private static final byte[] NUMBERS = new byte[]{46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    final byte[] cache;
    final Bytes encoded;
    final int size;
    byte[] swap;
    LongBits status;
    boolean phased;
    Genotype genotype = null;

    TextGenotypesFormatter(int size) {
        this.size = size;
        this.cache = new byte[4 * size];
        this.phased = false;
        int index = 0;
        this.swap = new byte[size];
        this.status = new LongBits(size);
        for (int i = 0; i < size; ++i) {
            this.cache[index++] = 9;
            this.cache[index++] = 46;
            this.cache[index++] = 47;
            this.cache[index++] = 46;
        }
        this.encoded = new Bytes(this.cache);
    }

    public Bytes flush(IGenotypes genotypes) {
        int count = genotypes.counter().size();
        if (count == 1) {
            Genotype genotype = genotypes.counter().argmax();
            if (genotype != this.genotype) {
                byte left = NUMBERS[genotype.left() + 1];
                byte right = NUMBERS[genotype.right() + 1];
                int offset = 1;
                int l = genotypes.size();
                for (int index = 0; index < l; ++index) {
                    this.cache[offset] = left;
                    this.cache[offset + 2] = right;
                    offset += 4;
                }
                this.genotype = genotype;
            }
        } else {
            genotypes.fill(this.swap, this.status);
            int index = 0;
            while ((index = this.status.nextSetBit(index)) != -1) {
                int offset = (index << 2) + 1;
                Genotype gty = Genotype.of(this.swap[index]);
                this.cache[offset] = NUMBERS[gty.left() + 1];
                this.cache[offset + 2] = NUMBERS[gty.right() + 1];
                ++index;
            }
            this.genotype = null;
        }
        if (this.phased != genotypes.isPhased()) {
            int offset = 1;
            byte sep = (byte)(genotypes.isPhased() ? 124 : 47);
            for (int gtyIndex = 0; gtyIndex < this.size; ++gtyIndex) {
                this.cache[offset + 1] = sep;
                offset += 4;
            }
            this.phased = genotypes.isPhased();
        }
        return this.encoded;
    }
}

