/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.vcf;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.exception.InvalidIndividualException;
import edu.sysu.pmglab.gtb.exception.InvalidVCFException;
import edu.sysu.pmglab.io.text.reader.IHeaderParser;
import edu.sysu.pmglab.io.text.reader.ISeparator;
import edu.sysu.pmglab.io.text.reader.Separator;

public class VCFHeader
implements IHeaderParser {
    final IndexableSet<String> individuals = new LinkedSet<String>();

    public static boolean isValidIndividual(String name) {
        if (name == null) {
            return false;
        }
        String regex = "^[a-zA-Z0-9 ._-]+$";
        if (name.length() > 255 || name.length() == 0) {
            return false;
        }
        return name.matches(regex);
    }

    @Override
    public boolean parse(Bytes data, ISeparator separator, IndexableSet<String> header) {
        if (data.length() >= 1 && data.fastByteAt(0) == 35) {
            List<String> cutValues = Separator.TAB.accept((data = data.trim()).subBytes(1)).apply(Bytes::toString);
            if (!(cutValues.size() > 4 && cutValues.fastGet(0).equals("CHROM") && cutValues.fastGet(1).equals("POS") && cutValues.fastGet(2).equals("ID") && cutValues.fastGet(3).equals("REF") && cutValues.fastGet(4).equals("ALT"))) {
                throw new InvalidVCFException(this.getMessage(data));
            }
            header.add("CHROM");
            header.add("POS");
            header.add("ID");
            header.add("REF");
            header.add("ALT");
            if (cutValues.size() >= 6 && !cutValues.fastGet(5).equals("QUAL")) {
                throw new InvalidVCFException(this.getMessage(data));
            }
            header.add("QUAL");
            if (cutValues.size() >= 7 && !cutValues.fastGet(6).equals("FILTER")) {
                throw new InvalidVCFException(this.getMessage(data));
            }
            header.add("FILTER");
            if (cutValues.size() >= 8 && !cutValues.fastGet(7).equals("INFO")) {
                throw new InvalidVCFException(this.getMessage(data));
            }
            header.add("INFO");
            if (cutValues.size() >= 9 && !cutValues.fastGet(8).equals("FORMAT")) {
                throw new InvalidVCFException(this.getMessage(data));
            }
            header.add("FORMAT");
            this.individuals.clear();
            if (cutValues.size() >= 10) {
                header.add("GENOTYPE");
                for (String individual : cutValues.subList(9, cutValues.size())) {
                    if (!VCFHeader.isValidIndividual(individual)) {
                        throw new InvalidIndividualException("Invalid individual: " + individual);
                    }
                    if (this.individuals.contains(individual)) {
                        throw new InvalidIndividualException("Duplicated individual: " + individual);
                    }
                    this.individuals.add(individual);
                }
            }
            return true;
        }
        throw new InvalidVCFException(this.getMessage(data));
    }

    private String getMessage(Bytes data) {
        return "The header line of this VCF file cannot be recognized: " + data;
    }

    public IndexableSet<String> getIndividuals() {
        return this.individuals.asUnmodifiable();
    }
}

