/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.vcf;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.bytecode.BytesSplitter;
import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.exception.InvalidVCFException;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.genome.coordinate.Coordinate;
import edu.sysu.pmglab.gtb.toolkit.vcf.VCFHeader;
import edu.sysu.pmglab.gtb.toolkit.vcf.parser.AllINFOParser;
import edu.sysu.pmglab.gtb.toolkit.vcf.parser.IGenotypeParser;
import edu.sysu.pmglab.gtb.toolkit.vcf.parser.INFOParser;
import edu.sysu.pmglab.gtb.toolkit.vcf.parser.IgnoreGenotypeParser;
import edu.sysu.pmglab.gtb.toolkit.vcf.parser.IgnoreINFOParser;
import edu.sysu.pmglab.gtb.toolkit.vcf.parser.StandardVCFGenotypeParser;
import edu.sysu.pmglab.gtb.toolkit.vcf.parser.VCFFormatParser;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.text.TextRecord;
import edu.sysu.pmglab.io.text.reader.CustomSeparator;
import edu.sysu.pmglab.io.text.reader.IMetadataParser;
import edu.sysu.pmglab.io.text.reader.ISeparator;
import edu.sysu.pmglab.io.text.reader.TextReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.IntFunction;

public class VCFReader
implements AutoCloseable,
Closeable {
    private static final ISeparator SEPARATOR = new CustomSeparator(new BiConsumer<Bytes, List<Bytes>>(){
        private final Bytes EMPTY = new Bytes(".");

        @Override
        public void accept(Bytes data, List<Bytes> values2) {
            data = data.trim();
            int mark = 0;
            int length = data.length();
            for (int start = 0; start < length; ++start) {
                if (data.fastByteAt(start) != 9) continue;
                values2.add(data.subBytes(mark, start));
                mark = start + 1;
                if (values2.size() < 9) continue;
            }
            values2.add(data.subBytes(mark));
            if (values2.size() <= 9) {
                for (int i = values2.size(); i < 9; ++i) {
                    values2.add(this.EMPTY);
                }
            }
        }
    });
    private static final FieldGroupMeta fields = new FieldGroupMeta(null, 5).addField("ID", FieldType.string).addField("QUAL", FieldType.string).addField("FILTER", FieldType.string).addField("INFO", FieldType.stringBytecodeMap).addField("FORMAT", FieldType.stringIndexableSet).asUnmodifiable();
    final LiveFile file;
    final IndexableSet<String> individuals;
    final TextReader reader;
    final TextRecord record;
    final IGenotypeParser genotypeParser;
    final INFOParser infoParser;
    final List<Function<Variant, Variant>> filters;
    final BytesSplitter splitter = new BytesSplitter(44);

    public VCFReader(String file) throws IOException {
        this(LiveFile.of(file));
    }

    public VCFReader(File file) throws IOException {
        this(LiveFile.of(file));
    }

    public VCFReader(LiveFile file) throws IOException {
        VCFReader reader = new Builder(file).instance();
        this.file = reader.file;
        this.reader = reader.reader;
        this.individuals = reader.individuals;
        this.genotypeParser = reader.genotypeParser;
        this.infoParser = reader.infoParser;
        this.record = reader.record;
        this.filters = reader.filters;
    }

    private VCFReader(LiveFile file, IndexableSet<String> individuals, TextReader reader, IGenotypeParser genotypeParser, INFOParser infoParser, List<Function<Variant, Variant>> filters) {
        this.file = file;
        this.reader = reader;
        this.individuals = individuals;
        this.genotypeParser = genotypeParser;
        this.infoParser = infoParser == null ? IgnoreINFOParser.INSTANCE : infoParser;
        this.record = this.reader.getRecord();
        this.filters = filters;
    }

    public static Builder setInput(String path) throws IOException {
        return new Builder(LiveFile.of(path));
    }

    public static Builder setInput(File path) throws IOException {
        return new Builder(LiveFile.of(path));
    }

    public static Builder setInput(LiveFile path) {
        return new Builder(path);
    }

    public IndexableSet<String> getIndividuals() {
        return this.individuals;
    }

    public LiveFile getFile() {
        return this.file;
    }

    public Variant read() throws IOException {
        block0: while (this.reader.read(this.record)) {
            int numOfAlleles = 1;
            Variant variant = new Variant(new Coordinate(Chromosome.get(this.record.get("CHROM").toString()), this.record.get("POS").toInt()));
            variant.addAllele(this.record.get("REF").toString());
            this.splitter.init(this.record.get("ALT"));
            while (this.splitter.hasNext()) {
                ++numOfAlleles;
                variant.addAllele(this.splitter.next().toString());
            }
            this.splitter.clear();
            if (variant.numOfAlleles() != numOfAlleles) {
                throw new InvalidVCFException("Variant " + variant.getCoordinate() + " contains duplicated alternative alleles: \n" + this.record.values().toString("\t"));
            }
            variant.setProperty("ID", this.record.get("ID").toString());
            variant.setProperty("QUAL", this.record.get("QUAL").toString());
            variant.setProperty("FILTER", this.record.get("FILTER").toString());
            variant.setProperty("INFO", this.infoParser.parse(this.record.get("INFO")));
            if (this.filters.size() > 0) {
                for (Function<Variant, Variant> filter : this.filters) {
                    variant = filter.apply(variant);
                    if (variant != null) continue;
                    continue block0;
                }
            }
            variant.setProperty("FORMAT", VCFFormatParser.parseFormat(this.record.get("FORMAT")));
            if (this.record.indexOf("GENOTYPE") != -1) {
                this.genotypeParser.parse(variant, this.record.get("GENOTYPE"));
            }
            return variant;
        }
        return null;
    }

    public ICCFMeta getMeta() {
        return this.reader.getMeta();
    }

    public FieldGroupMeta getAllFields() {
        return fields;
    }

    public long tell() {
        return this.reader.tell();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
        this.genotypeParser.close();
    }

    static {
        Variant.addPropertyKey("ID");
        Variant.addPropertyKey("QUAL");
        Variant.addPropertyKey("INFO");
        Variant.addPropertyKey("FILTER");
        Variant.addPropertyKey("FORMAT");
    }

    public static class Builder {
        final LiveFile path;
        boolean share = true;
        List<Function<Variant, Variant>> filters = new List();
        IntFunction<IGenotypeParser> genotypeParser = size -> new StandardVCFGenotypeParser(size, false);
        INFOParser infoParser = AllINFOParser.INSTANCE;

        private Builder(LiveFile path) {
            this.path = path;
        }

        public Builder setGenotypeParser(IntFunction<IGenotypeParser> parser) {
            this.genotypeParser = parser == null ? size -> new IgnoreGenotypeParser(size, false) : parser;
            return this;
        }

        public Builder setInfoParser(INFOParser parser) {
            this.infoParser = parser == null ? AllINFOParser.INSTANCE : parser;
            return this;
        }

        public FieldGroupMeta getAllFields() {
            return fields;
        }

        public int numOfFields() throws IOException {
            return fields.numOfFields();
        }

        public Builder share(boolean share) {
            this.share = share;
            return this;
        }

        public LiveFile getFile() {
            return this.path;
        }

        public Builder addFilter(Function<Variant, Variant> filter) {
            if (filter != null) {
                this.filters.add(filter);
            }
            return this;
        }

        public VCFReader instance() throws IOException {
            VCFHeader header = new VCFHeader();
            TextReader reader = TextReader.setInput(this.path).setHeaderParser(header).share(this.share).setMetadataParser(IMetadataParser.BEGIN_WITH_2_NUMBER_SIGN).setSeparator(SEPARATOR).instance();
            IndexableSet<String> individuals = header.getIndividuals();
            return new VCFReader(this.path, individuals, reader, this.genotypeParser.apply(individuals.size()), this.infoParser, this.filters);
        }

        public List<VCFReader> instance(int nParts) throws IOException {
            VCFHeader header = new VCFHeader();
            List<TextReader> readers = TextReader.setInput(this.path).setHeaderParser(header).setMetadataParser(IMetadataParser.BEGIN_WITH_2_NUMBER_SIGN).setSeparator(SEPARATOR).share(this.share).instance(nParts);
            IndexableSet<String> individuals = header.getIndividuals();
            return readers.apply(reader -> new VCFReader(this.path, individuals, (TextReader)reader, this.genotypeParser.apply(individuals.size()), this.infoParser, this.filters));
        }
    }
}

