/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.vcf;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.bytecode.ASCIIUtility;
import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.meta.CCFMeta;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.container.interval.LongInterval;
import edu.sysu.pmglab.gtb.exception.InvalidIndividualException;
import edu.sysu.pmglab.gtb.exception.InvalidVCFException;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.coordinate.Chromosome;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.genome.genotype.IGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.container.ConstantGenotypes;
import edu.sysu.pmglab.gtb.toolkit.vcf.TextGenotypesFormatter;
import edu.sysu.pmglab.gtb.toolkit.vcf.VCFHeader;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.io.bgzip.BGZIPConstants;
import edu.sysu.pmglab.io.bgzip.pbgzip.IBGZIPWriterStream;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.partreader.BoundReader;
import edu.sysu.pmglab.io.reader.IReaderStream;
import edu.sysu.pmglab.io.reader.ISeekableReaderStream;
import edu.sysu.pmglab.io.writer.ChannelAppendStream;
import edu.sysu.pmglab.io.writer.IWriterStream;
import edu.sysu.pmglab.io.writer.StdoutStream;
import edu.sysu.pmglab.io.writer.WriterStream;
import edu.sysu.pmglab.pconsumer.PBGZIPBlockEncoder;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class VCFWriter
implements AutoCloseable,
Closeable {
    private static final ThreadLocal<ByteStream> temps = ThreadLocal.withInitial(ByteStream::new);
    final File tempDir;
    final File file;
    final IndexableSet<String> individuals;
    final AtomicBoolean closed = new AtomicBoolean(false);
    final PBGZIPBlockEncoder encoder;
    final PartWriter[] writers;

    private VCFWriter(IWriterStream writer, File file, int nParts, IndexableSet<String> individuals, PBGZIPBlockEncoder encoder) throws IOException {
        this.file = file;
        this.individuals = individuals;
        this.tempDir = nParts > 1 ? RuntimeProperty.createTempDir() : null;
        this.encoder = encoder;
        this.writers = new PartWriter[nParts];
        this.writers[0] = new PartWriter(writer, file, this.individuals.size());
    }

    public static Builder stdout() {
        return new Builder();
    }

    public static Builder setOutput(String file) {
        return new Builder(file);
    }

    public static Builder setOutput(File file) {
        return new Builder(file);
    }

    public static Bytes CHROM_TO_ASCII(Chromosome chromosome) {
        return chromosome == null ? Chromosome.UNKNOWN.toBytes() : chromosome.toBytes();
    }

    public static Bytes POS_TO_ASCII(int position) {
        return new Bytes(ASCIIUtility.toASCII(position));
    }

    public static Bytes ID_TO_ASCII(Object id, Variant variant) {
        ByteStream container;
        Object typedID;
        if (id instanceof Bytes) {
            typedID = (Bytes)id;
            if (((Bytes)typedID).length() != 0) {
                return typedID;
            }
        } else if (id != null && ((String)(typedID = id.toString())).length() != 0) {
            return new Bytes((String)typedID);
        }
        if (variant == null) {
            return Bytes.byteToBytes((byte)46);
        }
        if (variant.numOfAlleles() == 0) {
            container = temps.get().clear();
            container.write(variant.getChromosome().toBytes());
            container.write(58);
            container.writeChar(variant.getPosition());
            return container.toBytes(true);
        }
        if (variant.numOfAlleles() == 1) {
            container = temps.get().clear();
            container.write(variant.getChromosome().toBytes());
            container.write(58);
            container.writeChar(variant.getPosition());
            container.write(95);
            container.writeChar(variant.alleleOfIndex(0));
            return container.toBytes(true);
        }
        if (variant.numOfAlleles() == 2) {
            container = temps.get().clear();
            container.write(variant.getChromosome().toBytes());
            container.write(58);
            container.writeChar(variant.getPosition());
            container.write(95);
            container.writeChar(variant.alleleOfIndex(0));
            container.write(95);
            container.writeChar(variant.alleleOfIndex(1));
            return container.toBytes(true);
        }
        container = temps.get().clear();
        container.write(variant.getChromosome().toBytes());
        container.write(58);
        container.writeChar(variant.getPosition());
        container.write(95);
        container.writeChar(variant.alleleOfIndex(0));
        container.write(95);
        container.writeChar(variant.alleleOfIndex(1));
        for (int i = 2; i < variant.numOfAlleles(); ++i) {
            container.write(59);
            container.write(variant.getChromosome().toBytes());
            container.write(58);
            container.writeChar(variant.getPosition());
            container.write(95);
            container.writeChar(variant.alleleOfIndex(0));
            container.write(95);
            container.writeChar(variant.alleleOfIndex(i));
        }
        return container.toBytes(true);
    }

    public static Bytes QUAL_TO_ASCII(Object qual) {
        String typedID;
        if (qual instanceof Bytes) {
            Bytes typedID2 = (Bytes)qual;
            if (typedID2.length() != 0) {
                return typedID2;
            }
        } else if (qual != null && (typedID = qual.toString()).length() != 0) {
            return new Bytes(typedID);
        }
        return Bytes.byteToBytes((byte)46);
    }

    public static Bytes FILTER_TO_ASCII(Object filter) {
        String typedID;
        if (filter instanceof Bytes) {
            Bytes typedID2 = (Bytes)filter;
            if (typedID2.length() != 0) {
                return typedID2;
            }
        } else if (filter != null && (typedID = filter.toString()).length() != 0) {
            return new Bytes(typedID);
        }
        return Bytes.byteToBytes((byte)46);
    }

    public static Bytes INFO_TO_ASCII(Object info) {
        if (info instanceof Bytes) {
            Bytes typedID = (Bytes)info;
            if (typedID.length() != 0) {
                return typedID;
            }
        } else {
            String typedID;
            if (info instanceof Map) {
                boolean empty = true;
                Map property = (Map)info;
                ByteStream writer = temps.get().clear();
                for (Object key : property.keySet()) {
                    if (!empty) {
                        writer.write(59);
                    }
                    empty = false;
                    writer.writeChar(key.toString());
                    if (property.get(key) == null) continue;
                    writer.write(61);
                    writer.writeChar(property.get(key).toString());
                }
                return writer.toBytes(true);
            }
            if (info != null && (typedID = info.toString()).length() != 0) {
                return new Bytes(typedID);
            }
        }
        return Bytes.byteToBytes((byte)46);
    }

    public static Bytes FORMAT_TO_ASCII(Object format) {
        if (format instanceof Bytes) {
            Bytes typedID = (Bytes)format;
            if (typedID.length() != 0) {
                return typedID;
            }
        } else {
            String typedID;
            if (format instanceof Iterable) {
                ByteStream container = temps.get().clear();
                for (Object metric : (Iterable)format) {
                    container.writeChar(metric.toString());
                    container.write(58);
                }
                if (container.length() > 0) {
                    container.wSeek(container.wTell() - 1);
                }
                return container.toBytes(true);
            }
            if (format != null && (typedID = format.toString()).length() != 0) {
                return new Bytes(typedID);
            }
        }
        return Bytes.byteToBytes((byte)46);
    }

    public VCFWriter write(Variant source2) throws IOException {
        return this.write(0, source2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VCFWriter write(int partIndex, Variant variant) throws IOException {
        if (this.closed.get()) {
            throw new IllegalStateException("IO Stream closed");
        }
        if (variant == null) {
            return this;
        }
        if (this.writers[partIndex] == null) {
            VCFWriter vCFWriter = this;
            synchronized (vCFWriter) {
                if (this.writers[partIndex] == null) {
                    if (this.encoder == null) {
                        File temp = new File(this.tempDir, "part_" + (partIndex + 1));
                        temp.deleteOnExit();
                        this.writers[partIndex] = new PartWriter(new WriterStream(temp, WriterStream.Option.DEFAULT), temp, this.individuals.size());
                    } else {
                        File temp = new File(this.tempDir, "part_" + (partIndex + 1) + ".gz");
                        temp.deleteOnExit();
                        this.writers[partIndex] = new PartWriter(IBGZIPWriterStream.instanceOf(temp, this.encoder), temp, this.individuals.size());
                    }
                }
            }
        }
        this.writers[partIndex].write(variant);
        return this;
    }

    public void finish(int partIndex) throws IOException {
        if (this.writers[partIndex] != null) {
            this.writers[partIndex].close();
        }
    }

    public int numOfParts() {
        return this.writers.length;
    }

    public long numOfVariants() {
        long count = 0L;
        for (PartWriter writer : this.writers) {
            if (writer == null) continue;
            count += writer.numOfVariants();
        }
        return count;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed.get()) {
            return;
        }
        this.closed.set(true);
        for (int i = 0; i < this.writers.length; ++i) {
            this.finish(i);
        }
        if (this.encoder != null) {
            this.encoder.stop();
        }
        if (this.writers.length > 1) {
            ChannelAppendStream output = new ChannelAppendStream(this.file);
            if (this.encoder != null) {
                output.seek(output.tell() - (long)BGZIPConstants.EMPTY_BGZIP_BLOCK.length);
                for (int i = 1; i < this.writers.length; ++i) {
                    if (this.writers[i] == null) continue;
                    File temp = this.writers[i].getFile();
                    if (this.writers[i].numOfVariants() > 0L) {
                        BoundReader reader = new BoundReader(LiveFile.of(temp).openAsBinary(), new LongInterval(0L, temp.length() - (long)BGZIPConstants.EMPTY_BGZIP_BLOCK.length));
                        reader.transferTo(0L, ((ISeekableReaderStream)reader).length(), output);
                        ((IReaderStream)reader).close();
                    }
                    FileUtils.delete(temp);
                }
                output.write(BGZIPConstants.EMPTY_BGZIP_BLOCK);
            } else {
                for (int i = 1; i < this.writers.length; ++i) {
                    if (this.writers[i] == null) continue;
                    File file = this.writers[i].getFile();
                    if (this.writers[i].numOfVariants() > 0L) {
                        ISeekableReaderStream reader = LiveFile.of(file).openAsBinary();
                        reader.transferTo(0L, reader.length(), output);
                        reader.close();
                    }
                    FileUtils.delete(file);
                }
            }
            output.close();
            FileUtils.delete(this.tempDir);
        }
    }

    public IndexableSet<String> getIndividuals() {
        return this.individuals;
    }

    public int numOfIndividuals() {
        return this.individuals.size();
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    static class PartWriter
    implements AutoCloseable,
    Closeable {
        final IWriterStream writer;
        final AtomicLong counter = new AtomicLong(0L);
        final AtomicBoolean closed = new AtomicBoolean(false);
        final File file;
        final TextGenotypesFormatter formatter;

        public PartWriter(IWriterStream writer, File file, int numOfIndividuals) {
            this.writer = writer;
            this.file = file;
            this.formatter = numOfIndividuals == 0 ? null : new TextGenotypesFormatter(numOfIndividuals);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PartWriter write(Variant source2) throws IOException {
            try {
                if (this.closed.get()) {
                    throw new IllegalStateException("Partial IO Stream closed");
                }
                this.writer.write(VCFWriter.CHROM_TO_ASCII(source2.getChromosome()));
                this.writer.write(9);
                this.writer.write(VCFWriter.POS_TO_ASCII(source2.getPosition()));
                this.writer.write(9);
                this.writer.write(VCFWriter.ID_TO_ASCII(source2.getProperty("ID"), null));
                this.writer.write(9);
                if (source2.numOfAlleles() == 0) {
                    this.writer.write(46);
                    this.writer.write(9);
                    this.writer.write(46);
                    this.writer.write(9);
                } else if (source2.numOfAlleles() == 1) {
                    this.writer.writeChar(source2.alleleOfIndex(0));
                    this.writer.write(9);
                    this.writer.write(46);
                    this.writer.write(9);
                } else if (source2.numOfAlleles() == 2) {
                    this.writer.writeChar(source2.alleleOfIndex(0));
                    this.writer.write(9);
                    this.writer.writeChar(source2.alleleOfIndex(1));
                    this.writer.write(9);
                } else {
                    this.writer.writeChar(source2.alleleOfIndex(0));
                    this.writer.write(9);
                    this.writer.writeChar(source2.alleleOfIndex(1));
                    int l = source2.numOfAlleles();
                    for (int i = 2; i < l; ++i) {
                        this.writer.write(44);
                        this.writer.writeChar(source2.alleleOfIndex(i));
                    }
                    this.writer.write(9);
                }
                this.writer.write(VCFWriter.QUAL_TO_ASCII(source2.getProperty("QUAL")));
                this.writer.write(9);
                this.writer.write(VCFWriter.FILTER_TO_ASCII(source2.getProperty("FILTER")));
                this.writer.write(9);
                this.writer.write(VCFWriter.INFO_TO_ASCII(source2.getProperty("INFO")));
                if (this.formatter != null) {
                    this.writer.write(9);
                    this.writer.writeChar("GT");
                    IGenotypes genotypes = source2.getGenotypes();
                    if (genotypes == null) {
                        genotypes = new ConstantGenotypes(this.formatter.size, null);
                    }
                    if (genotypes.size() != this.formatter.size) {
                        throw new InvalidVCFException("Invalid genotypes: " + source2.getCoordinate() + " takes " + this.formatter.size + " genotypes, but " + genotypes.size() + " given");
                    }
                    if (source2.numOfAlleles() <= 9 || genotypes.counter().maxAlleleIndex() <= 9) {
                        this.writer.write(this.formatter.flush(genotypes));
                    } else {
                        boolean phased = genotypes.isPhased();
                        int l = genotypes.size();
                        for (int i = 0; i < l; ++i) {
                            Genotype genotype = genotypes.get(i);
                            this.writer.write(9);
                            this.writer.write(genotype.toASCII(phased));
                        }
                    }
                }
                this.writer.write(10);
            }
            finally {
                this.counter.addAndGet(1L);
            }
            return this;
        }

        @Override
        public void close() throws IOException {
            if (!this.closed.get()) {
                this.writer.close();
                this.closed.set(true);
            }
        }

        public long numOfVariants() {
            return this.counter.get();
        }

        public File getFile() {
            return this.file;
        }
    }

    public static class Builder {
        final File path;
        final IndexableSet<String> individuals = new LinkedSet<String>();
        final CCFMeta meta = new CCFMeta();
        int compressorLevel;

        private Builder() {
            this.path = null;
            this.compressorLevel = -2;
        }

        private Builder(String path) {
            if (path == null) {
                this.path = null;
                this.compressorLevel = -2;
            } else {
                this.path = new File(path);
                this.compressorLevel = FileUtils.withExtension(path, ".gz", ".bgz") ? 5 : -2;
            }
        }

        private Builder(File path) {
            if (path == null) {
                this.path = null;
                this.compressorLevel = -2;
            } else {
                this.path = path;
                this.compressorLevel = FileUtils.withExtension(path, ".gz", ".bgz") ? 5 : -2;
            }
        }

        public Builder setCompressionLevel(int level) {
            this.compressorLevel = level == -2 ? -2 : BGZIPConstants.checkCompressionLevel(level);
            return this;
        }

        public int getCompressorLevel() {
            return this.compressorLevel;
        }

        public boolean isCompressionEnabled() {
            return this.compressorLevel != -2;
        }

        public IndexableSet<String> getIndividuals() {
            return this.individuals.asUnmodifiable();
        }

        public Builder setIndividuals(Iterable<String> individuals) {
            this.individuals.clear();
            if (individuals != null) {
                for (String individual : individuals) {
                    if (!VCFHeader.isValidIndividual(individual)) {
                        throw new InvalidIndividualException("Invalid individual: " + individual);
                    }
                    this.individuals.add(individual);
                }
            }
            return this;
        }

        public Builder clearIndividuals() {
            this.individuals.clear();
            return this;
        }

        public Builder addIndividual(String individual) {
            if (!VCFHeader.isValidIndividual(individual)) {
                throw new InvalidIndividualException("Invalid individual: " + individual);
            }
            this.individuals.add(individual);
            return this;
        }

        public Builder addIndividuals(String ... individuals) {
            if (individuals != null) {
                for (String individual : individuals) {
                    if (!VCFHeader.isValidIndividual(individual)) {
                        throw new InvalidIndividualException("Invalid individual: " + individual);
                    }
                    this.individuals.add(individual);
                }
            }
            return this;
        }

        public Builder addIndividuals(Iterable<String> individuals) {
            if (individuals != null) {
                for (String individual : individuals) {
                    if (!VCFHeader.isValidIndividual(individual)) {
                        throw new InvalidIndividualException("Invalid individual: " + individual);
                    }
                    this.individuals.add(individual);
                }
            }
            return this;
        }

        public int numOfIndividuals() {
            return this.individuals.size();
        }

        public ICCFMeta getMeta() {
            return this.meta.asUnmodifiable();
        }

        public Builder addMeta(CCFMetaItem meta) {
            this.meta.add(meta);
            return this;
        }

        public Builder addMeta(String key) {
            this.meta.add(key);
            return this;
        }

        public Builder addMeta(String key, String value) {
            this.meta.add(key, value);
            return this;
        }

        public Builder addMeta(Iterable<CCFMetaItem> metas) {
            this.meta.adds(metas);
            return this;
        }

        public Builder dropDuplicateMeta() {
            this.meta.dropDuplicates();
            return this;
        }

        public Builder clearMetas() {
            this.meta.clear();
            return this;
        }

        public VCFWriter instance() throws IOException {
            return this.instance(1);
        }

        public VCFWriter instance(int nParts) throws IOException {
            PBGZIPBlockEncoder encoder;
            IWriterStream writer;
            nParts = Math.max(1, nParts);
            if (this.path != null && this.path.exists()) {
                FileUtils.deleteFile(this.path);
                if (this.path.exists()) {
                    throw new FileSystemException("Readonly file stream: " + this.path);
                }
            }
            IndexableSet individuals = new LinkedSet<String>(this.individuals).asUnmodifiable();
            if (this.compressorLevel == -2) {
                writer = this.path == null ? new StdoutStream() : new WriterStream(this.path, WriterStream.Option.DEFAULT);
                encoder = null;
            } else if (this.path == null) {
                writer = IBGZIPWriterStream.instanceOf(new StdoutStream(), this.compressorLevel, nParts);
                encoder = null;
            } else if (nParts == 1) {
                writer = IBGZIPWriterStream.instanceOf(this.path, this.compressorLevel, nParts);
                encoder = null;
            } else {
                encoder = (PBGZIPBlockEncoder)new PBGZIPBlockEncoder(this.compressorLevel, nParts).start();
                writer = IBGZIPWriterStream.instanceOf(this.path, encoder);
            }
            if (this.meta.size() == 0) {
                writer.writeChar("##fileformat=VCFv4.5\n");
                writer.writeChar("##FORMAT=<ID=GT,Number=1,Type=String,Description=\"Genotype\">\n");
                for (Chromosome chromosome : Chromosome.values()) {
                    writer.writeChar("##contig=<ID=" + chromosome.getName() + ">\n");
                }
            } else {
                for (CCFMetaItem item : this.meta.filter(meta -> !meta.getKey().startsWith("$"))) {
                    writer.write(35);
                    writer.write(35);
                    writer.writeChar(item.toString());
                    writer.write(10);
                }
            }
            if (individuals.size() > 0) {
                writer.writeChar("#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO\tFORMAT");
                for (String individual : individuals) {
                    writer.write(9);
                    writer.writeChar(individual);
                }
                writer.writeChar("\n");
            } else {
                writer.writeChar("#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO\n");
            }
            if (this.path == null) {
                return new VCFWriter(writer, null, 1, individuals, null);
            }
            return new VCFWriter(writer, this.path, nParts, individuals, encoder);
        }

        public File getFile() {
            return this.path;
        }
    }
}

