/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.vcf.parser;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.bytecode.BytesSplitter;
import edu.sysu.pmglab.container.indexable.ConcurrentLinkedSet;
import edu.sysu.pmglab.container.indexable.DynamicIndexableMap;
import edu.sysu.pmglab.container.indexable.IndexableMap;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.gtb.toolkit.vcf.parser.INFOParser;

public enum AllINFOParser implements INFOParser
{
    INSTANCE;

    final IndexableSet<String> keys = new ConcurrentLinkedSet<String>();

    public IndexableMap<String, Bytes> parse(Bytes info) {
        if (info.length() == 0 || info.length() == 1 && info.fastByteAt(0) == 46) {
            return IndexableMap.EMPTY();
        }
        DynamicIndexableMap<String, Bytes> dict = new DynamicIndexableMap<String, Bytes>(this.keys);
        BytesSplitter splitter = new BytesSplitter(59).init(info);
        while (splitter.hasNext()) {
            String key;
            Bytes sequence2 = splitter.next();
            if (sequence2.length() <= 0) continue;
            int equalIndex = sequence2.indexOf((byte)61);
            if (equalIndex == -1) {
                key = sequence2.toString();
                ((IndexableMap)dict).put(key, null);
                continue;
            }
            key = sequence2.subBytes(0, equalIndex).toString();
            ((IndexableMap)dict).put(key, sequence2.subBytes(equalIndex + 1));
        }
        if (((IndexableMap)dict).size() == 0) {
            return IndexableMap.EMPTY();
        }
        return dict.asUnmodifiable();
    }
}

