/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.vcf.parser;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.bytecode.BytesSplitter;
import edu.sysu.pmglab.container.indexable.DynamicIndexableMap;
import edu.sysu.pmglab.container.indexable.IndexableMap;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.gtb.toolkit.vcf.parser.INFOParser;

public class SpecifiedINFOParser
implements INFOParser {
    private final IndexableSet<String> fields;

    public SpecifiedINFOParser(String ... fields) {
        this.fields = new LinkedSet<String>(fields).asUnmodifiable();
    }

    public SpecifiedINFOParser(Iterable<String> fields) {
        this.fields = new LinkedSet<String>(fields).asUnmodifiable();
    }

    public IndexableMap<String, Bytes> parse(Bytes info) {
        if (this.fields.size() == 0 || info.length() == 0 || info.length() == 1 && info.fastByteAt(0) == 46) {
            return IndexableMap.EMPTY();
        }
        int count = this.fields.size();
        DynamicIndexableMap<String, Bytes> dict = new DynamicIndexableMap<String, Bytes>(this.fields);
        BytesSplitter splitter = new BytesSplitter(59).init(info);
        while (splitter.hasNext()) {
            String key;
            Bytes sequence2 = splitter.next();
            if (sequence2.length() <= 0) continue;
            int equalIndex = sequence2.indexOf((byte)61);
            if (equalIndex == -1) {
                key = sequence2.toString();
                if (this.fields.contains(key)) {
                    ((IndexableMap)dict).put(key, null);
                    --count;
                }
            } else {
                key = sequence2.subBytes(0, equalIndex).toString();
                if (this.fields.contains(key)) {
                    ((IndexableMap)dict).put(key, sequence2.subBytes(equalIndex + 1));
                    --count;
                }
            }
            if (count != 0) continue;
            break;
        }
        if (count == this.fields.size()) {
            return IndexableMap.EMPTY();
        }
        return dict.asUnmodifiable();
    }
}

