/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.vcf.parser;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.bytecode.BytesSplitter;
import edu.sysu.pmglab.bytecode.GroupSplitter;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.exception.InvalidVCFException;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.genome.genotype.IGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.container.ConstantGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.container.Genotypes;
import edu.sysu.pmglab.gtb.genome.genotype.container.LargeGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.container.LiteGenotypes;
import edu.sysu.pmglab.gtb.toolkit.vcf.parser.IGenotypeParser;
import edu.sysu.pmglab.gtb.toolkit.vcf.parser.VCFFormatParser;
import edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.genotype.IGenotypeController;
import gnu.trove.map.hash.THashMap;
import java.util.Map;

public class StandardVCFGenotypeParser
implements IGenotypeParser {
    final Map<String, IGenotypeController> controllers = new THashMap<String, IGenotypeController>();
    final List<IGenotypeController> validControllers = new List(0);
    final GroupSplitter groupSplitter = new GroupSplitter(9, 58);
    final BytesSplitter valueSplitter = new BytesSplitter(1, 9);
    final IGenotypes EMPTY;
    final IGenotypes[] genotypes;

    public StandardVCFGenotypeParser(int size, boolean phased) {
        this.EMPTY = new ConstantGenotypes(size, phased, Genotype.MISSING);
        this.genotypes = new IGenotypes[3];
    }

    @Override
    public void parse(Variant variant, Bytes sequence2) {
        IGenotypes genotypes;
        IndexableSet format = (IndexableSet)variant.getProperty("FORMAT");
        int gtIndex = format.size() == 0 ? -1 : (format == VCFFormatParser.GT ? 0 : format.indexOf("GT"));
        if (gtIndex == -1) {
            variant.setGenotypes(this.EMPTY);
            variant.setProperty("FORMAT", VCFFormatParser.GT);
            return;
        }
        if (variant.numOfAlleles() <= 15) {
            if (this.genotypes[0] == null) {
                this.genotypes[0] = new LiteGenotypes(this.EMPTY.size(), this.EMPTY.isPhased());
            }
            genotypes = this.genotypes[0];
        } else if (variant.numOfAlleles() <= 255) {
            if (this.genotypes[1] == null) {
                this.genotypes[1] = new Genotypes(this.EMPTY.size(), this.EMPTY.isPhased());
            }
            genotypes = this.genotypes[1];
        } else {
            if (this.genotypes[2] == null) {
                this.genotypes[2] = new LargeGenotypes(this.EMPTY.size(), this.EMPTY.isPhased());
            }
            genotypes = this.genotypes[2];
        }
        int individualIndex = 0;
        if (format.size() == 1) {
            this.valueSplitter.init(sequence2);
            while (this.valueSplitter.hasNext()) {
                genotypes.set(individualIndex++, this.valueSplitter.next().toGenotype());
            }
            this.valueSplitter.clear();
        } else if (gtIndex == 0) {
            int maxIndex = -1;
            this.validControllers.clear();
            if (this.controllers.size() > 0) {
                int l = format.size() - 1;
                for (int i = 0; i < l; ++i) {
                    String keyword = (String)format.valueOf(i + 1);
                    IGenotypeController controller = this.controllers.get(keyword);
                    if (controller != null) {
                        maxIndex = i;
                    }
                    this.validControllers.add(controller);
                }
            }
            this.groupSplitter.init(sequence2);
            if (maxIndex == -1) {
                while (this.groupSplitter.hasNext()) {
                    Bytes individual = this.groupSplitter.next();
                    genotypes.set(individualIndex++, individual.toGenotype());
                    this.groupSplitter.nextGroup();
                }
            } else {
                while (this.groupSplitter.hasNext()) {
                    Bytes individual = this.groupSplitter.next();
                    Genotype genotype = individual.toGenotype();
                    int metricIndex = 0;
                    if (genotype != Genotype.MISSING) {
                        while (this.groupSplitter.hasNext()) {
                            Bytes metric = this.groupSplitter.next();
                            IGenotypeController controller = this.validControllers.fastGet(metricIndex);
                            if (controller != null && !controller.execute(metric, genotype)) {
                                genotype = Genotype.MISSING;
                                break;
                            }
                            if (metricIndex >= maxIndex) break;
                            ++metricIndex;
                        }
                    }
                    genotypes.set(individualIndex++, genotype);
                    this.groupSplitter.nextGroup();
                }
            }
            this.groupSplitter.clear();
        } else {
            throw new InvalidVCFException("When 'GT' is included, it should be the first field in FORMAT");
        }
        if (individualIndex != genotypes.size()) {
            throw new InvalidVCFException("Expected " + genotypes.size() + " individual, but " + individualIndex + " found: " + variant.getCoordinate().toString());
        }
        variant.setGenotypes(genotypes);
        variant.setProperty("FORMAT", VCFFormatParser.GT);
    }

    @Override
    public StandardVCFGenotypeParser setController(IGenotypeController controllers) {
        if (controllers != null) {
            if (controllers.getKeyWord().equals("GT")) {
                throw new InvalidVCFException("'GT' is not a genotype quality metric in VCF file");
            }
            this.controllers.put(controllers.getKeyWord(), controllers);
        }
        return this;
    }

    @Override
    public void close() {
        this.genotypes[0] = null;
        this.genotypes[1] = null;
        this.genotypes[2] = null;
        this.groupSplitter.clear();
        this.valueSplitter.clear();
    }
}

