/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.vcf.parser;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.gtb.exception.InvalidVCFException;
import gnu.trove.map.hash.THashMap;
import java.util.Map;

public class VCFFormatParser {
    public static final IndexableSet<String> GT = new LinkedSet<String>(new String[]{"GT"}).asUnmodifiable();
    private static final Map<String, IndexableSet<String>> CACHE = new THashMap<String, IndexableSet<String>>();

    private VCFFormatParser() {
        throw new UnsupportedOperationException("Cannot instantiate utility class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IndexableSet<String> parseFormat(Bytes format) {
        if (format.length() == 0 || format.length() == 1 && format.fastByteAt(0) == 46) {
            return IndexableSet.EMPTY();
        }
        if (format.length() == 2 && format.fastByteAt(0) == 71 && format.fastByteAt(1) == 84) {
            return GT;
        }
        String formatted = format.toString();
        IndexableSet<String> returns = CACHE.get(formatted);
        if (returns == null) {
            Map<String, IndexableSet<String>> map = CACHE;
            synchronized (map) {
                returns = CACHE.get(formatted);
                if (returns == null) {
                    LinkedSet<String> formats = new LinkedSet<String>();
                    String[] metrics = formatted.split(":");
                    for (String metric : formatted.split(":")) {
                        if (formats.contains(metric)) {
                            throw new InvalidVCFException("Duplicated VCF FORMAT field: '" + metric + "' in '" + format + "'");
                        }
                        formats.add(metric);
                    }
                    returns = formats.asUnmodifiable();
                    CACHE.put(formatted, returns);
                }
            }
        }
        return returns;
    }
}

