/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.genotype;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.bytecode.BytesSplitter;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.genotype.IGenotypeController;
import edu.sysu.pmglab.utils.Assert;

public class GenotypeADController
implements IGenotypeController {
    public static final float HOMOZYGOUS_REF_DEFAULT = 0.95f;
    public static final float HOMOZYGOUS_REF_MIN = 0.0f;
    public static final float HOMOZYGOUS_REF_MAX = 1.0f;
    public static final float HOMOZYGOUS_ALT_DEFAULT = 0.75f;
    public static final float HOMOZYGOUS_ALT_MIN = 0.0f;
    public static final float HOMOZYGOUS_ALT_MAX = 1.0f;
    public static final float HETEROZYGOUS_DEFAULT = 0.25f;
    public static final float HETEROZYGOUS_MIN = 0.0f;
    public static final float HETEROZYGOUS_MAX = 1.0f;
    final float homozygousRefMethod;
    final float homozygousAltMethod;
    final float heterozygousMethod;
    final int dpMethod;
    private final BytesSplitter splitter = new BytesSplitter(1, 44);

    public GenotypeADController() {
        this(8, 0.95f, 0.75f, 0.25f);
    }

    public GenotypeADController(int dpMethod, float homozygousRefMethod, float homozygousAltMethod, float heterozygousMethod) {
        Assert.valueRange(dpMethod, 0, 0x7FFFFFFD);
        Assert.valueRange(Float.valueOf(homozygousRefMethod), Float.valueOf(0.0f), Float.valueOf(1.0f));
        Assert.valueRange(Float.valueOf(homozygousAltMethod), Float.valueOf(0.0f), Float.valueOf(1.0f));
        Assert.valueRange(Float.valueOf(heterozygousMethod), Float.valueOf(0.0f), Float.valueOf(1.0f));
        this.dpMethod = dpMethod;
        this.homozygousRefMethod = homozygousRefMethod;
        this.homozygousAltMethod = homozygousAltMethod;
        this.heterozygousMethod = heterozygousMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(Bytes metric, Genotype genotype) {
        if (genotype.getAN() != 2 || metric.length() == 0 || metric.length() == 1 && metric.fastByteAt(0) == 46) {
            return true;
        }
        this.splitter.init(metric);
        try {
            int dp = 0;
            int index = 0;
            if (genotype.isHomozygous()) {
                if (genotype.left() == 0) {
                    int adRef = 0;
                    while (this.splitter.hasNext()) {
                        Bytes value = this.splitter.next();
                        if (index == 0) {
                            adRef = value.toInt();
                            dp += adRef;
                        } else {
                            dp += value.toInt();
                        }
                        ++index;
                    }
                    if (dp < this.dpMethod) {
                        boolean value = false;
                        return value;
                    }
                    boolean value = (float)adRef >= (float)dp * this.homozygousRefMethod;
                    return value;
                }
                int adAlt = 0;
                while (this.splitter.hasNext()) {
                    Bytes value = this.splitter.next();
                    if (index == genotype.left()) {
                        adAlt = value.toInt();
                        dp += adAlt;
                    } else {
                        dp += value.toInt();
                    }
                    ++index;
                }
                if (dp < this.dpMethod) {
                    boolean value = false;
                    return value;
                }
                boolean value = (float)adAlt >= (float)dp * this.homozygousAltMethod;
                return value;
            }
            int adAltLeft = 0;
            int adAltRight = 0;
            while (this.splitter.hasNext()) {
                Bytes value = this.splitter.next();
                if (index == genotype.left()) {
                    adAltLeft = value.toInt();
                    dp += adAltLeft;
                } else if (index == genotype.right()) {
                    adAltRight = value.toInt();
                    dp += adAltRight;
                } else {
                    dp += value.toInt();
                }
                ++index;
            }
            if (dp < this.dpMethod) {
                boolean value = false;
                return value;
            }
            float heterozygousMethod = (float)dp * this.heterozygousMethod;
            if (genotype.left() == 0) {
                boolean bl = (float)adAltRight >= heterozygousMethod;
                return bl;
            }
            if (genotype.right() == 0) {
                boolean bl = (float)adAltLeft >= heterozygousMethod;
                return bl;
            }
            boolean bl = (float)adAltLeft >= heterozygousMethod && (float)adAltRight >= heterozygousMethod;
            return bl;
        }
        finally {
            this.splitter.clear();
        }
    }

    @Override
    public String getKeyWord() {
        return "AD";
    }

    public String toString() {
        return "AD_HOM_REF >= " + (1.0f - this.homozygousRefMethod) + "AD_HOM_ALT >= " + this.homozygousAltMethod + "AD_HET >= " + this.heterozygousMethod;
    }
}

