/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.genotype;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.genotype.IGenotypeController;
import edu.sysu.pmglab.utils.Assert;

public class GenotypeDPController
implements IGenotypeController {
    public static final int DEFAULT = 8;
    public static final int MIN = 0;
    public static final int MAX = 0x7FFFFFFD;
    final int method;

    public GenotypeDPController() {
        this(8);
    }

    public GenotypeDPController(int method) {
        Assert.valueRange(method, 0, 0x7FFFFFFD);
        this.method = method;
    }

    @Override
    public String getKeyWord() {
        return "DP";
    }

    public String toString() {
        return "DP >= " + this.method;
    }

    @Override
    public boolean execute(Bytes metric, Genotype genotype) {
        if (metric.length() == 0 || metric.length() == 1 && metric.fastByteAt(0) == 46) {
            return true;
        }
        return metric.toInt() >= this.method;
    }
}

