/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.genotype;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.genotype.IGenotypeController;
import java.util.Set;

public class GenotypeFTController
implements IGenotypeController {
    final List<Bytes> values;
    final int size;

    public GenotypeFTController(String ... labels) {
        this.values = new List(labels.length);
        for (String label : labels) {
            if (label.length() <= 0) continue;
            this.values.add(new Bytes(label));
        }
        this.size = this.values.size();
    }

    public GenotypeFTController(Set<String> labels) {
        this.values = new List(labels.size());
        for (String label : labels) {
            if (label.length() <= 0) continue;
            this.values.add(new Bytes(label));
        }
        this.size = this.values.size();
    }

    @Override
    public String getKeyWord() {
        return "FT";
    }

    public String toString() {
        return "FT in {" + this.values.toString(", ") + "}";
    }

    @Override
    public boolean execute(Bytes metric, Genotype genotype) {
        for (int i = 0; i < this.values.size(); ++i) {
            if (!metric.valueEquals(this.values.fastGet(i))) continue;
            return true;
        }
        return false;
    }
}

