/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.genotype;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.bytecode.BytesSplitter;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.genotype.IGenotypeController;
import edu.sysu.pmglab.utils.Assert;

public class GenotypeLADController
implements IGenotypeController {
    public static final float HOMOZYGOUS_ALT_DEFAULT = 0.75f;
    public static final float HOMOZYGOUS_ALT_MIN = 0.0f;
    public static final float HOMOZYGOUS_ALT_MAX = 1.0f;
    public static final float HETEROZYGOUS_DEFAULT = 0.25f;
    public static final float HETEROZYGOUS_MIN = 0.0f;
    public static final float HETEROZYGOUS_MAX = 1.0f;
    final float homozygousAltMethod;
    final float heterozygousMethod;
    final int dpMethod;
    private final BytesSplitter splitter = new BytesSplitter(1, 44);

    public GenotypeLADController() {
        this(8, 0.75f, 0.25f);
    }

    public GenotypeLADController(int dpMethod, float homozygousAltMethod, float heterozygousMethod) {
        Assert.valueRange(dpMethod, 0, 0x7FFFFFFD);
        Assert.valueRange(Float.valueOf(homozygousAltMethod), Float.valueOf(0.0f), Float.valueOf(1.0f));
        Assert.valueRange(Float.valueOf(heterozygousMethod), Float.valueOf(0.0f), Float.valueOf(1.0f));
        this.dpMethod = dpMethod;
        this.homozygousAltMethod = homozygousAltMethod;
        this.heterozygousMethod = heterozygousMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(Bytes metric, Genotype genotype) {
        if (genotype.getAN() != 2 || metric.length() == 0 || metric.length() == 1 && metric.fastByteAt(0) == 46) {
            return true;
        }
        if (genotype.isHomozygous()) {
            if (genotype.left() == 0) {
                return metric.toInt() >= this.dpMethod;
            }
            this.splitter.init(metric);
            try {
                int ad = 0;
                int dp = 0;
                int index = 0;
                while (this.splitter.hasNext()) {
                    Bytes value = this.splitter.next();
                    if (index == 0) {
                        dp += value.toInt();
                    } else if (index == 1) {
                        ad = value.toInt();
                        dp += ad;
                    }
                    ++index;
                }
                if (index != 2) {
                    throw new IllegalArgumentException("Unsupported LAD '" + metric + "' for genotype '" + genotype + "'");
                }
                if (dp < this.dpMethod) {
                    boolean value = false;
                    return value;
                }
                boolean value = (float)ad >= (float)dp * this.homozygousAltMethod;
                return value;
            }
            finally {
                this.splitter.clear();
            }
        }
        if (genotype.left() == 0 || genotype.right() == 0) {
            this.splitter.init(metric);
            try {
                int ad = 0;
                int dp = 0;
                int index = 0;
                while (this.splitter.hasNext()) {
                    Bytes value = this.splitter.next();
                    if (index == 0) {
                        dp += value.toInt();
                    } else if (index == 1) {
                        ad = value.toInt();
                        dp += ad;
                    }
                    ++index;
                }
                if (index != 2) {
                    throw new IllegalArgumentException("Unsupported LAD '" + metric + "' for genotype '" + genotype + "'");
                }
                if (dp < this.dpMethod) {
                    boolean value = false;
                    return value;
                }
                boolean value = (float)ad >= (float)dp * this.heterozygousMethod;
                return value;
            }
            finally {
                this.splitter.clear();
            }
        }
        this.splitter.init(metric);
        try {
            int ad1 = 0;
            int ad2 = 0;
            int dp = 0;
            int index = 0;
            while (this.splitter.hasNext()) {
                Bytes value = this.splitter.next();
                if (index == 0) {
                    dp += value.toInt();
                } else if (index == 1) {
                    ad1 = value.toInt();
                    dp += ad1;
                } else if (index == 2) {
                    ad2 = value.toInt();
                    dp += ad2;
                }
                ++index;
            }
            if (index != 3) {
                throw new IllegalArgumentException("Unsupported LAD '" + metric + "' for genotype '" + genotype + "'");
            }
            if (dp < this.dpMethod) {
                boolean value = false;
                return value;
            }
            float method = (float)dp * this.heterozygousMethod;
            boolean bl = (float)ad1 >= method && (float)ad2 >= method;
            return bl;
        }
        finally {
            this.splitter.clear();
        }
    }

    @Override
    public String getKeyWord() {
        return "LAD";
    }

    public String toString() {
        return "LAD_HOM_ALT >= " + this.homozygousAltMethod + "LAD_HET >= " + this.heterozygousMethod;
    }
}

