/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.genotype;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.bytecode.BytesSplitter;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.genome.genotype.container.PLTypedGenotypes;
import edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.genotype.IGenotypeController;

public class GenotypePLController
implements IGenotypeController {
    public static final int DEFAULT = 20;
    public static final int MIN = 0;
    public static final int MAX = 0x7FFFFFFD;
    final int method;
    final BytesSplitter splitter = new BytesSplitter(1, 44);

    public GenotypePLController() {
        this(20);
    }

    public GenotypePLController(int method) {
        this.method = method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean execute(Bytes metric, Genotype genotype) {
        if (metric.length() == 0) return true;
        if (metric.length() == 1 && metric.fastByteAt(0) == 46) {
            return true;
        }
        boolean hasZero = false;
        int index = 0;
        this.splitter.init(metric);
        try {
            while (this.splitter.hasNext()) {
                Bytes value = this.splitter.next();
                int score = value.toInt();
                if (score == 0) {
                    if (hasZero) {
                        boolean bl = false;
                        return bl;
                    }
                    if (PLTypedGenotypes.toGenotype(index) != genotype) {
                        boolean bl = false;
                        return bl;
                    }
                    hasZero = true;
                } else if (score < this.method) {
                    boolean bl = false;
                    return bl;
                }
                ++index;
            }
            if (hasZero) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.splitter.clear();
        }
    }

    @Override
    public String getKeyWord() {
        return "PL";
    }

    public String toString() {
        return "second lowest PL >= " + this.method;
    }
}

