/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.variant;

public class HardyWeinbergCalculator {
    private static final double SMALL_EPSILON = 5.684341886080802E-14;
    private static final double EXACT_TEST_BIAS = 1.0339757656912846E-25;

    private HardyWeinbergCalculator() {
        throw new UnsupportedOperationException("Cannot instantiate utility class");
    }

    public static double calculate(int obsAA, int obsAB, int obsBB, boolean midp) {
        double currHetsT2;
        long obsHomr;
        long obsHomc;
        if (obsAA < obsBB) {
            obsHomc = obsBB;
            obsHomr = obsAA;
        } else {
            obsHomc = obsAA;
            obsHomr = obsBB;
        }
        long rareCopies = 2L * obsHomr + (long)obsAB;
        long genotypes2 = ((long)obsAB + obsHomc + obsHomr) * 2L;
        int tieCount = 1;
        double currHomrT2 = obsHomr;
        double currHomcT2 = obsHomc;
        double tailp = 1.0339757656912258E-25;
        double centerp = 0.0;
        double lastP2 = tailp;
        double lastP1 = tailp;
        if (genotypes2 == 0L) {
            return midp ? 0.5 : 1.0;
        }
        if ((long)obsAB * genotypes2 > rareCopies * (genotypes2 - rareCopies)) {
            double preAddP;
            for (currHetsT2 = (double)obsAB; currHetsT2 > 1.5; currHetsT2 -= 2.0) {
                lastP2 *= currHetsT2 * (currHetsT2 - 1.0) / (4.0 * (currHomrT2 += 1.0) * (currHomcT2 += 1.0));
                if (!(lastP2 < 1.0339757656912846E-25)) continue;
                if (lastP2 > 1.033975765691167E-25) {
                    ++tieCount;
                }
                tailp += lastP2;
                break;
            }
            if (centerp == 0.0 && !midp) {
                return 1.0;
            }
            while (currHetsT2 > 1.5) {
                lastP2 *= currHetsT2 * (currHetsT2 - 1.0) / (4.0 * (currHomrT2 += 1.0) * (currHomcT2 += 1.0));
                currHetsT2 -= 2.0;
                if (!((tailp += lastP2) <= (preAddP = tailp))) continue;
            }
            double currHetsT1 = obsAB + 2;
            double currHomrT1 = obsHomr;
            double currHomcT1 = obsHomc;
            while (currHomrT1 > 0.5 && !((tailp += (lastP1 *= 4.0 * currHomrT1 * currHomcT1 / (currHetsT1 * (currHetsT1 - 1.0)))) <= (preAddP = tailp))) {
                currHetsT1 += 2.0;
                currHomrT1 -= 1.0;
                currHomcT1 -= 1.0;
            }
        } else {
            double preAddP;
            while (currHomrT2 > 0.5) {
                lastP2 *= 4.0 * currHomrT2 * currHomcT2 / ((currHetsT2 += 2.0) * (currHetsT2 - 1.0));
                currHomrT2 -= 1.0;
                currHomcT2 -= 1.0;
                if (lastP2 < 1.0339757656912846E-25) {
                    if (lastP2 > 1.033975765691167E-25) {
                        ++tieCount;
                    }
                    tailp += lastP2;
                    break;
                }
                if ((centerp += lastP2) != Double.POSITIVE_INFINITY) continue;
                return 0.0;
            }
            if (centerp == 0.0 && !midp) {
                return 1.0;
            }
            while (currHomrT2 > 0.5) {
                lastP2 *= 4.0 * currHomrT2 * currHomcT2 / ((currHetsT2 += 2.0) * (currHetsT2 - 1.0));
                currHomrT2 -= 1.0;
                currHomcT2 -= 1.0;
                if (!((tailp += lastP2) <= (preAddP = tailp))) continue;
            }
            double currHomrT1 = obsHomr;
            double currHomcT1 = obsHomc;
            for (double currHetsT1 = (double)obsAB; currHetsT1 > 1.5 && !((tailp += (lastP1 *= currHetsT1 * (currHetsT1 - 1.0) / (4.0 * (currHomrT1 += 1.0) * (currHomcT1 += 1.0)))) <= (preAddP = tailp)); currHetsT1 -= 2.0) {
            }
        }
        if (!midp) {
            return tailp / (tailp + centerp);
        }
        return (tailp - 5.169878828456129E-26 * (double)tieCount) / (tailp + centerp);
    }
}

