/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.variant;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.container.interval.DoubleInterval;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.variant.IVariantController;
import java.util.Map;

public class NumericalController
implements IVariantController {
    final DoubleInterval range;
    final String keyword;

    public NumericalController(String keyword, DoubleInterval range) {
        this.keyword = keyword;
        this.range = range == null ? new DoubleInterval(Double.NaN, Double.NaN) : range;
    }

    @Override
    public boolean filter(Variant variant) {
        Map values2 = (Map)variant.getProperty("INFO");
        if (values2 == null) {
            return true;
        }
        Bytes value = (Bytes)values2.get(this.getKeyWord());
        if (value == null || value.length() == 0 || value.length() == 1 && value.fastByteAt(0) == 46) {
            return true;
        }
        try {
            return this.range.contains(value.toDouble(), true);
        }
        catch (NumberFormatException e) {
            return true;
        }
    }

    @Override
    public String getKeyWord() {
        return this.keyword;
    }
}

