/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.variant;

import edu.sysu.pmglab.container.interval.FloatInterval;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.genotype.counter.ICounter;
import edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.variant.IVariantController;

public class VariantAFController
implements IVariantController {
    final FloatInterval method;
    public static final FloatInterval RANGE = new FloatInterval(0.0f, 1.0f);

    public VariantAFController(FloatInterval method) {
        this.method = RANGE.getOverlaps(method);
    }

    @Override
    public boolean filter(Variant variant) {
        ICounter counter = variant.getGenotypes().counter();
        return !Float.isNaN(counter.getAF()) && this.method.contains(counter.getAF(), true);
    }

    public String toString() {
        return this.method.start() + " <= AF <= " + this.method.end();
    }

    @Override
    public String getKeyWord() {
        return "AF";
    }
}

