/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.variant;

import edu.sysu.pmglab.container.interval.IntInterval;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.genotype.counter.ICounter;
import edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.variant.IVariantController;

public class VariantANController
implements IVariantController {
    final IntInterval method;
    public static final IntInterval RANGE = new IntInterval(0, Integer.MAX_VALUE);

    public VariantANController(IntInterval method) {
        this.method = RANGE.getOverlaps(method);
    }

    @Override
    public boolean filter(Variant variant) {
        ICounter counter = variant.getGenotypes().counter();
        return this.method.contains(counter.getAN());
    }

    public String toString() {
        if (this.method.end() == Integer.MAX_VALUE) {
            return "AN >= " + this.method.start();
        }
        return this.method.start() + " <= AN <= " + this.method.end();
    }

    @Override
    public String getKeyWord() {
        return "AN";
    }
}

