/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.variant;

import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.gtb.genome.Variant;
import edu.sysu.pmglab.gtb.genome.genotype.Genotype;
import edu.sysu.pmglab.gtb.genome.genotype.counter.ICounter;
import edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.variant.HardyWeinbergCalculator;
import edu.sysu.pmglab.gtb.toolkit.vcf.qualitycontrol.variant.IVariantController;

public class VariantHWEController
implements IVariantController {
    private static final IFilter<Genotype> AA_COUNTER = genotype -> genotype.intcode() == 2;
    private static final IFilter<Genotype> BB_COUNTER = genotype -> genotype.getAN() == 2 && genotype.getAC() == 1;
    private static final IFilter<Genotype> AB_COUNTER = genotype -> genotype.getAC() == 2;
    final double method;
    final boolean midP;

    public VariantHWEController() {
        this.method = 1.0E-6;
        this.midP = true;
    }

    public VariantHWEController(double method, boolean middle) {
        this.method = method;
        this.midP = middle;
    }

    @Override
    public boolean filter(Variant variant) {
        int obsBB;
        int obsAB;
        ICounter counter = variant.getGenotypes().counter();
        int obsAA = counter.count(AA_COUNTER);
        return HardyWeinbergCalculator.calculate(obsAA, obsAB = counter.count(AB_COUNTER), obsBB = counter.count(BB_COUNTER), this.midP) <= this.method;
    }

    public String toString() {
        return "p value of HWE-test < " + this.method;
    }

    @Override
    public String getKeyWord() {
        return "HWE";
    }
}

