/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.gtb.viewer;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.CCFReader;
import edu.sysu.pmglab.ccf.CCFTable;
import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.filter.CCFFilter;
import edu.sysu.pmglab.ccf.record.BoxRecord;
import edu.sysu.pmglab.ccf.type.Box;
import edu.sysu.pmglab.ccf.viewer.ReaderAdaptor;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.indexable.LinkedSet;
import edu.sysu.pmglab.container.interval.LongInterval;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.gtb.GTBManager;
import edu.sysu.pmglab.gtb.GTBReaderOption;
import edu.sysu.pmglab.gtb.genome.genotype.IGenotypes;
import edu.sysu.pmglab.gtb.genome.genotype.counter.ICounter;
import edu.sysu.pmglab.io.file.LiveFile;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class GTBViewerReader
implements ReaderAdaptor {
    final CCFReader reader;
    final CCFFilter filter;
    final Map<String, IndexableSet<String>> fields = new LinkedHashMap<String, IndexableSet<String>>();
    final GTBReaderOption option;
    final int numOfFields;

    public GTBViewerReader(String path) throws IOException {
        this(path, null);
    }

    public GTBViewerReader(LiveFile path) throws IOException {
        this(path, null);
    }

    public GTBViewerReader(GTBManager manager) throws IOException {
        this(manager, null);
    }

    public GTBViewerReader(GTBReaderOption manager) throws IOException {
        this(manager, null);
    }

    public GTBViewerReader(String path, CCFFilter filter) throws IOException {
        this(new GTBManager(path), filter);
    }

    public GTBViewerReader(LiveFile path, CCFFilter filter) throws IOException {
        this(new GTBManager(path), filter);
    }

    public GTBViewerReader(GTBManager manager, CCFFilter filter) throws IOException {
        this(new GTBReaderOption(manager, true, true), filter);
    }

    public GTBViewerReader(final GTBReaderOption option, CCFFilter filter) throws IOException {
        this.option = option;
        this.reader = new CCFReader(option);
        this.filter = filter;
        final AtomicInteger count = new AtomicInteger(0);
        for (final FieldGroupMeta group : this.reader.getAllFields().getAllFieldGroups()) {
            this.fields.put(group.groupName(), (IndexableSet<String>)new LinkedSet<String>(){
                {
                    if (group.groupName() == null) {
                        if (option.loadGenotype()) {
                            for (FieldMeta field : group) {
                                if (!this.add(field.simpleName())) continue;
                                count.addAndGet(1);
                                this.add(field.simpleName());
                            }
                        } else {
                            for (FieldMeta field : group) {
                                if (field.simpleName().equals("GT")) continue;
                                count.addAndGet(1);
                                this.add(field.simpleName());
                            }
                        }
                    } else {
                        for (FieldMeta field : group) {
                            count.addAndGet(1);
                            this.add(field.simpleName());
                        }
                    }
                }
            });
        }
        this.numOfFields = count.get();
    }

    @Override
    public Map<String, IndexableSet<String>> getHeader() {
        return Collections.unmodifiableMap(this.fields);
    }

    @Override
    public Object[] read() throws IOException {
        BoxRecord record = this.reader.getRecord();
        int index = 0;
        if (this.filter == null) {
            if (this.reader.read(record)) {
                Object[] objects = new Object[this.numOfFields];
                for (String group : this.fields.keySet()) {
                    Bytes data;
                    if (group == null) {
                        for (String simple : this.fields.get(null)) {
                            if (simple.equals("CHROM")) {
                                objects[index++] = record.get(null, "CHROM");
                                continue;
                            }
                            if (simple.equals("POS")) {
                                objects[index++] = record.get(null, "POS");
                                continue;
                            }
                            if (simple.equals("ALLELE")) {
                                objects[index++] = List.wrap((IndexableSet)record.get(null, "ALLELE")).toString(",");
                                continue;
                            }
                            if (simple.equals("GT")) {
                                Bytes GT = (Bytes)record.get(null, "GT");
                                ICounter counter = IGenotypes.load(GT).counter();
                                ByteStream container = ByteStream.getThreadInstance();
                                container.writeChar("AC");
                                container.write(61);
                                container.writeChar(counter.getAC());
                                container.write(59);
                                container.writeChar("AN");
                                container.write(61);
                                container.writeChar(counter.getAN());
                                container.write(59);
                                container.writeChar("AF");
                                container.write(61);
                                container.writeChar(counter.getAF());
                                container.write(59);
                                container.writeChar("GT_COUNT");
                                container.write(61);
                                container.write(123);
                                container.writeChar(counter.toString());
                                container.write(125);
                                objects[index++] = container.getString(container.length());
                                continue;
                            }
                            data = ((Box)record.getBox(null, simple)).toBytes();
                            if (data.length() >= 200) {
                                objects[index++] = "<not loaded>";
                                continue;
                            }
                            objects[index++] = data.toString();
                        }
                        continue;
                    }
                    for (String simple : this.fields.get(group)) {
                        data = ((Box)record.getBox(group, simple)).toBytes();
                        if (data.length() >= 200) {
                            objects[index++] = "<not loaded>";
                            continue;
                        }
                        objects[index++] = data.toString();
                    }
                }
                return objects;
            }
        } else {
            long pointer = this.filter.filter();
            if (pointer != -1L) {
                this.reader.seek(pointer);
                this.reader.read(record);
                Object[] objects = new Object[this.numOfFields];
                for (String group : this.fields.keySet()) {
                    Bytes data;
                    if (group == null) {
                        for (String simple : this.fields.get(null)) {
                            if (simple.equals("CHROM")) {
                                objects[index++] = record.get(null, "CHROM");
                                continue;
                            }
                            if (simple.equals("POS")) {
                                objects[index++] = record.get(null, "POS");
                                continue;
                            }
                            if (simple.equals("ALLELE")) {
                                objects[index++] = List.wrap((IndexableSet)record.get(null, "ALLELE")).toString(",");
                                continue;
                            }
                            if (simple.equals("GT")) {
                                Bytes GT = (Bytes)record.get(null, "GT");
                                ICounter counter = IGenotypes.load(GT).counter();
                                ByteStream container = ByteStream.getThreadInstance();
                                container.writeChar("AC");
                                container.write(61);
                                container.writeChar(counter.getAC());
                                container.write(59);
                                container.writeChar("AN");
                                container.write(61);
                                container.writeChar(counter.getAN());
                                container.write(59);
                                container.writeChar("AF");
                                container.write(61);
                                container.writeChar(counter.getAF());
                                container.write(59);
                                container.writeChar("GT_COUNT");
                                container.write(61);
                                container.write(123);
                                container.writeChar(counter.toString());
                                container.write(125);
                                objects[index++] = container.getString(container.length());
                                continue;
                            }
                            data = ((Box)record.getBox(null, simple)).toBytes();
                            if (data.length() >= 200) {
                                objects[index++] = "<not loaded>";
                                continue;
                            }
                            objects[index++] = data.toString();
                        }
                        continue;
                    }
                    for (String simple : this.fields.get(group)) {
                        data = ((Box)record.getBox(group, simple)).toBytes();
                        if (data.length() >= 200) {
                            objects[index++] = "<not loaded>";
                            continue;
                        }
                        objects[index++] = data.toString();
                    }
                }
                return objects;
            }
        }
        return null;
    }

    @Override
    public long numOfRecords() {
        return this.reader.numOfRecords();
    }

    @Override
    public void seek(long pointer) throws IOException {
        this.reader.seek(pointer);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
        if (this.filter != null) {
            this.filter.close();
        }
    }

    @Override
    public LongInterval available() {
        return this.reader.available();
    }

    @Override
    public long tell() {
        return this.reader.tell();
    }

    @Override
    public CCFTable getTable() {
        return this.reader.getTable();
    }

    @Override
    public String toString() {
        return this.option.getGTBManager().toString();
    }
}

