/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.internet;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.io.reader.ReaderStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.SocketException;
import java.net.URL;
import java.net.URLEncoder;
import javax.net.ssl.HttpsURLConnection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public enum NCBIRetriever {
    INSTANCE;

    public static final Logger logger;

    public static String[] pubMedIDESearch(String fieldType, List<String> diseaseNames, List<String> keyValues, List<String> filterValues, int retryTimes, boolean[] succeeded) throws Exception {
        String[] lastRetrievedResults;
        Object line = null;
        if (diseaseNames.isEmpty() || keyValues.isEmpty()) {
            return null;
        }
        String[] params = new String[8];
        StringBuilder allParams = new StringBuilder();
        allParams.append(URLEncoder.encode("db", "UTF-8"));
        allParams.append("=");
        allParams.append(URLEncoder.encode("pubmed", "UTF-8"));
        allParams.append("&");
        allParams.append(URLEncoder.encode("term", "UTF-8"));
        allParams.append("=");
        params[0] = "db";
        params[1] = "pubmed";
        int diseaseNameNum = diseaseNames.size();
        int keyValuesNum = keyValues.size();
        StringBuilder diseaseStr = new StringBuilder();
        for (int i = 0; i < diseaseNameNum; ++i) {
            String diseaseName = diseaseNames.get(i);
            if (diseaseName == null || diseaseName.trim().isEmpty()) continue;
            if (diseaseName.indexOf(32) >= 0) {
                diseaseStr.append("(");
                diseaseStr.append(diseaseName.replace(" ", "+").toLowerCase());
                diseaseStr.append(fieldType).append(")");
            } else {
                diseaseStr.append(diseaseName.toLowerCase());
                diseaseStr.append(fieldType);
            }
            diseaseStr.append("+OR+");
        }
        StringBuilder geneStr = new StringBuilder();
        for (int i = 0; i < keyValuesNum; ++i) {
            String geneName = keyValues.get(i);
            if (geneName == null || geneName.trim().isEmpty()) continue;
            if (geneName.indexOf(32) >= 0) {
                geneStr.append("(");
                geneStr.append(geneName.replace(" ", "+"));
                geneStr.append(fieldType).append(")");
            } else {
                geneStr.append(geneName);
                geneStr.append(fieldType);
            }
            geneStr.append("+OR+");
        }
        StringBuilder filterStr = new StringBuilder();
        if (filterValues != null) {
            int filterValuesNum = filterValues.size();
            for (String filterName : filterValues) {
                if (filterName == null || filterName.trim().isEmpty()) continue;
                if (filterName.indexOf(32) >= 0) {
                    filterStr.append("(");
                    filterStr.append(filterName.replace(' ', '+'));
                    filterStr.append(fieldType).append(")");
                } else {
                    filterStr.append(filterName);
                    filterStr.append(fieldType);
                }
                filterStr.append("+OR+");
            }
        }
        allParams.append("((");
        allParams.append(diseaseStr.substring(0, diseaseStr.length() - 4));
        allParams.append(")+AND+(");
        allParams.append(geneStr.substring(0, geneStr.length() - 4));
        if (filterStr.length() > 0) {
            allParams.append(")+AND+(");
            allParams.append(filterStr.substring(0, filterStr.length() - 4));
        }
        allParams.append("))");
        params[2] = "term";
        params[3] = "(" + diseaseStr.substring(0, diseaseStr.length() - 4) + ")+AND+(" + geneStr.substring(0, geneStr.length() - 4) + ")";
        allParams.append("&");
        allParams.append(URLEncoder.encode("datetype", "UTF-8"));
        allParams.append("=");
        allParams.append(URLEncoder.encode("edat", "UTF-8"));
        allParams.append("&");
        allParams.append(URLEncoder.encode("retmax", "UTF-8"));
        allParams.append("=");
        allParams.append(URLEncoder.encode("100", "UTF-8"));
        params[4] = "datetype";
        params[5] = "edat";
        params[6] = "retmax";
        params[7] = "100";
        StringBuilder retryInfo = new StringBuilder();
        int count = 0;
        while ((lastRetrievedResults = NCBIRetriever.retrievePubMedIDs(allParams.toString())) == null) {
            if (++count <= retryTimes) continue;
            succeeded[0] = false;
            break;
        }
        System.out.print("Searching " + keyValues.toString());
        if (succeeded[0]) {
            System.out.println(" succeeded!");
        } else {
            System.out.println(" failed!");
        }
        if (lastRetrievedResults != null) {
            // empty if block
        }
        return lastRetrievedResults;
    }

    public static String[] pubMedIDESearchInTitleAbstract(List<String> diseaseNames, List<String> keyValues, List<String> filterValues, int retryTimes) throws Exception {
        String[] lastRetrievedResults;
        Object line = null;
        if (diseaseNames.isEmpty() || keyValues.isEmpty()) {
            return null;
        }
        StringBuilder content1 = new StringBuilder();
        content1.append(URLEncoder.encode("db", "UTF-8"));
        content1.append("=");
        content1.append(URLEncoder.encode("pubmed", "UTF-8"));
        content1.append("&");
        content1.append(URLEncoder.encode("term", "UTF-8"));
        content1.append("=");
        int diseaseNameNum = diseaseNames.size();
        int keyValuesNum = keyValues.size();
        StringBuilder diseaseStr = new StringBuilder();
        for (int i = 0; i < diseaseNameNum; ++i) {
            String diseaseName = diseaseNames.get(i);
            diseaseName = diseaseNames.get(i);
            if (diseaseName == null || diseaseName.trim().length() == 0) continue;
            if (diseaseName.indexOf(32) >= 0) {
                diseaseStr.append("(");
                diseaseStr.append(diseaseName.replace(' ', '+').toLowerCase());
                diseaseStr.append("[tiab])");
            } else {
                diseaseStr.append(diseaseName.toLowerCase());
                diseaseStr.append("[tiab]");
            }
            diseaseStr.append("+OR+");
        }
        StringBuilder geneStr = new StringBuilder();
        for (int i = 0; i < keyValuesNum; ++i) {
            String geneName = keyValues.get(i);
            if (geneName == null || geneName.trim().length() == 0) continue;
            if (geneName.indexOf(32) >= 0) {
                geneStr.append("(");
                geneStr.append(geneName.replace(' ', '+'));
                geneStr.append("[tiab])");
            } else {
                geneStr.append(geneName);
                geneStr.append("[tiab]");
            }
            geneStr.append("+OR+");
        }
        StringBuilder filterStr = new StringBuilder();
        if (filterValues != null) {
            int filterValuesNum = filterValues.size();
            for (int i = 0; i < filterValuesNum; ++i) {
                String filterName = filterValues.get(i);
                if (filterName == null || filterName.trim().length() == 0) continue;
                if (filterName.indexOf(32) >= 0) {
                    filterStr.append("(");
                    filterStr.append(filterName.replace(' ', '+'));
                    filterStr.append("[tiab])");
                } else {
                    filterStr.append(filterName);
                    filterStr.append("[tiab]");
                }
                filterStr.append("+OR+");
            }
        }
        content1.append("((");
        content1.append(diseaseStr.substring(0, diseaseStr.length() - 4));
        content1.append(")+AND+(");
        content1.append(geneStr.substring(0, geneStr.length() - 4));
        if (filterStr.length() > 0) {
            content1.append(")+AND+(");
            content1.append(filterStr.substring(0, filterStr.length() - 4));
        }
        content1.append("))");
        content1.append("&");
        content1.append(URLEncoder.encode("datetype", "UTF-8"));
        content1.append("=");
        content1.append(URLEncoder.encode("edat", "UTF-8"));
        content1.append("&");
        content1.append(URLEncoder.encode("retmax", "UTF-8"));
        content1.append("=");
        content1.append(URLEncoder.encode("100", "UTF-8"));
        int maxRetry = 10;
        StringBuilder retryInfo = new StringBuilder();
        int count = 0;
        while ((lastRetrievedResults = NCBIRetriever.retrievePubMedIDs(content1.toString())) == null) {
            if (++count <= maxRetry) continue;
            System.out.println("Connection aborted finally!!");
            break;
        }
        if (lastRetrievedResults != null) {
            // empty if block
        }
        return lastRetrievedResults;
    }

    static String[] retrievePubMedIDsWithAllFields(String content1) {
        List<String> idList = new List<String>();
        DocumentBuilderFactory domfac = DocumentBuilderFactory.newInstance();
        try {
            Thread.sleep(6000L);
            URL url = new URL("https://eutils.ncbi.nlm.nih.gov/entrez/eutils/esearch.fcgi?");
            HttpsURLConnection urlConn = (HttpsURLConnection)url.openConnection();
            urlConn.setDoInput(true);
            urlConn.setDoOutput(true);
            urlConn.setConnectTimeout(3000);
            urlConn.setReadTimeout(3000);
            OutputStreamWriter wr = new OutputStreamWriter(urlConn.getOutputStream());
            System.out.println(url.toString() + content1);
            wr.write(content1);
            wr.flush();
            DocumentBuilder dombuilder = domfac.newDocumentBuilder();
            Document doc = dombuilder.parse(urlConn.getInputStream());
            Element root = doc.getDocumentElement();
            NodeList nodes = root.getElementsByTagName("Count");
            if (nodes.getLength() == 1) {
                Element e = (Element)nodes.item(0);
                Text t = (Text)e.getFirstChild();
                if (t == null) {
                    return null;
                }
                int count = Integer.parseInt(t.getNodeValue());
                if (count == 0) {
                    return idList.toArray((T1[])new String[0]);
                }
            }
            nodes = root.getElementsByTagName("Id");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element subNode = (Element)nodes.item(i);
                Text t = (Text)subNode.getFirstChild();
                idList.add(t.getNodeValue());
            }
            return idList.toArray((T1[])new String[0]);
        }
        catch (SocketException ex) {
            System.out.print("Retry ");
            return null;
        }
        catch (IOException ex) {
            System.out.print("Retry ");
            return null;
        }
        catch (ParserConfigurationException ex) {
            return null;
        }
        catch (SAXException ex) {
            return null;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    static String[] retrievePubMedIDs0(String content1) {
        List<String> idList = new List<String>();
        DocumentBuilderFactory domfac = DocumentBuilderFactory.newInstance();
        try {
            Thread.sleep(6000L);
            URL url = new URL("https://eutils.ncbi.nlm.nih.gov/entrez/eutils/esearch.fcgi?");
            HttpsURLConnection urlConn = (HttpsURLConnection)url.openConnection();
            urlConn.setDoInput(true);
            urlConn.setDoOutput(true);
            urlConn.setConnectTimeout(3000);
            urlConn.setReadTimeout(3000);
            OutputStreamWriter wr = new OutputStreamWriter(urlConn.getOutputStream());
            System.out.println(url.toString() + content1);
            wr.write(content1);
            wr.flush();
            DocumentBuilder dombuilder = domfac.newDocumentBuilder();
            Document doc = dombuilder.parse(urlConn.getInputStream());
            Element root = doc.getDocumentElement();
            NodeList nodes = root.getElementsByTagName("Count");
            if (nodes.getLength() == 1) {
                Element e = (Element)nodes.item(0);
                Text t = (Text)e.getFirstChild();
                if (t == null) {
                    return null;
                }
                int count = Integer.parseInt(t.getNodeValue());
                if (count == 0) {
                    return idList.toArray((T1[])new String[0]);
                }
            }
            nodes = root.getElementsByTagName("Id");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element subNode = (Element)nodes.item(i);
                Text t = (Text)subNode.getFirstChild();
                idList.add(t.getNodeValue());
            }
            return idList.toArray((T1[])new String[0]);
        }
        catch (SocketException ex) {
            System.out.print("Retry ");
            return null;
        }
        catch (IOException ex) {
            System.out.print("Retry ");
            return null;
        }
        catch (ParserConfigurationException ex) {
            return null;
        }
        catch (SAXException ex) {
            return null;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    static String[] retrievePubMedIDs(String content1) {
        try {
            Thread.sleep(6000L);
            List<String> idList = new List<String>();
            String urlString = "https://eutils.ncbi.nlm.nih.gov/entrez/eutils/esearch.fcgi?" + content1;
            try (ReaderStream reader = new ReaderStream(urlString, ReaderStream.Option.HTTP);){
                Bytes cache = null;
                int entriesSearched = 0;
                while ((cache = reader.readline()) != null) {
                    String line = cache.toString();
                    if (line.contains("<Count>")) {
                        line = line.replaceAll("[^\\d.]", "");
                    }
                    if (!line.contains("<Id>")) continue;
                    line = line.replaceAll("[^\\d.]", "");
                    ++entriesSearched;
                    idList.add(line.trim());
                }
            }
            return idList.toArray((T1[])new String[0]);
        }
        catch (SocketException ex) {
            return null;
        }
        catch (IOException ex) {
            return null;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        logger = LoggerFactory.getLogger("KGGA - PubMed Searching");
    }
}

