/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io;

import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.container.list.List;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.stream.Stream;

public class FileUtils {
    private FileUtils() {
        throw new UnsupportedOperationException("Cannot instantiate utility class");
    }

    public static boolean isDirectory(File file) {
        return file.isDirectory();
    }

    public static boolean isDirectory(String src) {
        return Paths.get(src, new String[0]).toFile().isDirectory();
    }

    public static File rename(String src, String dest) throws IOException {
        return Files.move(Paths.get(src, new String[0]), Paths.get(dest, new String[0]), StandardCopyOption.REPLACE_EXISTING).toAbsolutePath().toFile();
    }

    public static File rename(String src, File dest) throws IOException {
        return Files.move(Paths.get(src, new String[0]), dest.toPath(), StandardCopyOption.REPLACE_EXISTING).toAbsolutePath().toFile();
    }

    public static File rename(File src, File dest) throws IOException {
        return Files.move(src.toPath(), dest.toPath(), StandardCopyOption.REPLACE_EXISTING).toAbsolutePath().toFile();
    }

    public static File rename(File src, String dest) throws IOException {
        return Files.move(src.toPath(), Paths.get(dest, new String[0]), StandardCopyOption.REPLACE_EXISTING).toAbsolutePath().toFile();
    }

    public static File copy(String src, String dest) throws IOException {
        return Files.copy(Paths.get(src, new String[0]), Paths.get(dest, new String[0]), StandardCopyOption.REPLACE_EXISTING).toAbsolutePath().toFile();
    }

    public static File copy(File src, String dest) throws IOException {
        return Files.copy(src.toPath(), Paths.get(dest, new String[0]), StandardCopyOption.REPLACE_EXISTING).toAbsolutePath().toFile();
    }

    public static String getSubFile(String parent, String fileName) {
        if (parent.endsWith("/")) {
            return parent + fileName;
        }
        return parent + "/" + fileName;
    }

    public static File getSubFile(File parent, String fileName) {
        return new File(FileUtils.getSubFile(parent.getPath(), fileName));
    }

    public static long size(String src) throws IOException {
        Path path = Paths.get(src, new String[0]);
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (Stream<Path> pathsStream = Files.walk(path, new FileVisitOption[0]);){
                long l = pathsStream.filter(p -> p.toFile().isFile()).mapToLong(p -> p.toFile().length()).sum();
                return l;
            }
        }
        return path.toFile().length();
    }

    public static long size(File src) throws IOException {
        return FileUtils.size(src.getPath());
    }

    public static String getExtension(String src) {
        if (FileUtils.isDirectory(src)) {
            return null;
        }
        String fileName = Paths.get(src, new String[0]).getFileName().toString();
        int index = fileName.lastIndexOf(46);
        if (index == -1 || index == fileName.length() - 1) {
            return "";
        }
        return fileName.substring(index + 1);
    }

    public static String getExtension(File src) {
        return FileUtils.getExtension(src.getPath());
    }

    public static boolean exists(String src) {
        return Paths.get(src, new String[0]).toFile().exists();
    }

    public static boolean exists(File src) {
        return src.exists();
    }

    public static boolean deleteFile(String src) throws IOException {
        return FileUtils.deleteFile(new File(src));
    }

    public static boolean deleteFile(File src) throws IOException {
        if (!src.isDirectory() && src.exists()) {
            return src.delete();
        }
        return false;
    }

    public static boolean delete(String src) throws IOException {
        Path path = Paths.get(src, new String[0]);
        return FileUtils.deleteRecursively(path);
    }

    public static boolean delete(File src) throws IOException {
        return FileUtils.deleteRecursively(src.toPath());
    }

    private static boolean deleteRecursively(Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            Files.list(path).sorted(Path::compareTo).forEach(p -> {
                try {
                    FileUtils.deleteRecursively(p);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        return Files.deleteIfExists(path);
    }

    public static boolean withExtension(String src, String ... extensions) {
        if (src == null || FileUtils.isDirectory(src) || extensions == null) {
            return false;
        }
        for (String extension : extensions) {
            if (!extension.startsWith(".")) {
                extension = "." + extension;
            }
            if (!src.endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    public static boolean withExtension(File src, String ... extensions) {
        return FileUtils.withExtension(src.getPath(), extensions);
    }

    public static File changeExtension(File src, String targetExtension, String ... matchers) {
        return new File(FileUtils.changeExtension(src.getPath(), targetExtension, matchers));
    }

    public static String changeExtension(String src, String targetExtension, String ... matchers) {
        targetExtension = targetExtension == null || targetExtension.length() == 0 ? "" : (targetExtension.startsWith(".") ? targetExtension : "." + targetExtension);
        List<String> matcherArray = new List<String>(matchers);
        matcherArray.sort((string1, string2) -> -Integer.compare(string1.length(), string2.length()));
        for (String match : matcherArray) {
            match = match.startsWith(".") ? match : "." + match;
            if (!src.endsWith(match)) continue;
            src = src.substring(0, src.length() - match.length()) + targetExtension;
            return src;
        }
        if (src.endsWith(targetExtension)) {
            return src;
        }
        return src + targetExtension;
    }

    public static String getParent(File src) {
        return FileUtils.getParent(src.getPath());
    }

    public static String getParent(String src) {
        URI uri = null;
        try {
            uri = URI.create(src);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (uri != null && uri.getScheme() != null) {
            int lastSlashIndex;
            String scheme = uri.getScheme();
            String authority = uri.getAuthority();
            String parentPath = uri.getPath();
            if (parentPath.endsWith("/")) {
                parentPath = parentPath.substring(0, parentPath.length() - 1);
            }
            parentPath = (lastSlashIndex = parentPath.lastIndexOf(47)) != -1 ? parentPath.substring(0, lastSlashIndex) : "/";
            return scheme + "://" + authority + parentPath;
        }
        Path path1 = Paths.get(src, new String[0]);
        return path1.getParent().toString();
    }

    public static boolean isSameFile(String src, String dst) throws IOException {
        return Files.isSameFile(Paths.get(src, new String[0]), Paths.get(dst, new String[0]));
    }

    public static boolean isSameFile(File src, File dst) throws IOException {
        return Files.isSameFile(src.toPath(), dst.toPath());
    }

    public static String getName(String address) {
        return new File(address).getName();
    }

    public static List<File> listFiles(File src) {
        return FileUtils.listFiles(new List<File>(), src, null);
    }

    public static List<File> listFiles(File src, IFilter<File> filter) {
        return FileUtils.listFiles(new List<File>(), src, filter);
    }

    public static List<File> listFiles(String src) {
        return FileUtils.listFiles(new List<File>(), new File(src), null);
    }

    public static List<File> listFiles(String src, IFilter<File> filter) {
        return FileUtils.listFiles(new List<File>(), new File(src), filter);
    }

    private static List<File> listFiles(List<File> container, File directory, IFilter<File> filter) {
        File[] filesList = directory.listFiles();
        if (filesList != null) {
            for (File file : filesList) {
                if (file.isFile()) {
                    if (filter != null && !filter.filter(file)) continue;
                    container.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                FileUtils.listFiles(container, file, filter);
            }
        }
        return container;
    }
}

