/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io.bgzip;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.io.bgzip.BGZIPConstants;
import edu.sysu.pmglab.io.reader.ISeekableReaderStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class BGZIPBlockDecoder {
    final Inflater inflater = new Inflater(true);
    final Bytes container;
    final byte[] cache = new byte[65536];
    final byte[] ioStreamCache = new byte[65540];

    public BGZIPBlockDecoder(boolean share) {
        this.container = share ? new Bytes() : null;
    }

    public long findBlock(ISeekableReaderStream adjuster) throws IOException {
        int accept = adjuster.read(this.ioStreamCache);
        if (accept >= 28) {
            for (int index = 0; index < accept - 4; ++index) {
                if (this.ioStreamCache[index] != 31 || this.ioStreamCache[index + 1] != -117 || this.ioStreamCache[index + 2] != 8 || this.ioStreamCache[index + 3] != 4) continue;
                long pointer = adjuster.tell() - (long)accept + (long)index;
                adjuster.seek(pointer);
                return pointer;
            }
        }
        adjuster.seek(Long.MAX_VALUE);
        return -1L;
    }

    public Bytes inflaterBlock(InputStream reader) throws IOException {
        int size;
        int compressedBlockSize;
        int accept = reader.read(this.ioStreamCache, 0, 28);
        if (accept == -1) {
            return null;
        }
        if (accept != 28) {
            throw new IOException("Invalid BGZIP block length");
        }
        int pointer = 0;
        for (int i = 0; i < BGZIPConstants.MAGIC_CODE.length; ++i) {
            if (BGZIPConstants.MAGIC_CODE[i] == this.ioStreamCache[i]) continue;
            throw new IOException("Invalid BGZIP block header");
        }
        pointer += BGZIPConstants.MAGIC_CODE.length;
        if ((accept = reader.read(this.ioStreamCache, 28, (compressedBlockSize = 1 + (this.ioStreamCache[pointer++] & 0xFF) + ((this.ioStreamCache[pointer++] & 0xFF) << 8)) - 28)) != compressedBlockSize - 28) {
            throw new IOException("Invalid BGZIP block length");
        }
        int deflatedSize = compressedBlockSize - 18 - 8;
        pointer += deflatedSize + 4;
        int originInputSize = (this.ioStreamCache[pointer++] & 0xFF) + ((this.ioStreamCache[pointer++] & 0xFF) << 8) + ((this.ioStreamCache[pointer++] & 0xFF) << 16) + ((this.ioStreamCache[pointer++] & 0xFF) << 24);
        this.inflater.reset();
        this.inflater.setInput(this.ioStreamCache, 18, deflatedSize);
        try {
            size = this.inflater.inflate(this.cache, 0, originInputSize);
        }
        catch (DataFormatException e) {
            throw new IOException("Invalid BGZIP block");
        }
        if (originInputSize != size) {
            throw new IOException("Invalid BGZIP block length");
        }
        if (size == 0) {
            return Bytes.EMPTY;
        }
        if (this.container != null) {
            this.container.reset(this.cache, 0, size);
            return this.container;
        }
        return new Bytes(this.cache, 0, size, true, false);
    }

    public Bytes inflaterBlock(byte[] src, int offset, int length) throws IOException {
        int size;
        int compressedBlockSize;
        if (length < 28 || length > 65536) {
            throw new IOException("Invalid BGZIP block");
        }
        int pointer = offset;
        for (int i = 0; i < BGZIPConstants.MAGIC_CODE.length; ++i) {
            if (BGZIPConstants.MAGIC_CODE[i] == src[offset + i]) continue;
            throw new IOException("Invalid BGZIP block header");
        }
        pointer += BGZIPConstants.MAGIC_CODE.length;
        if ((compressedBlockSize = 1 + (src[pointer++] & 0xFF) + ((src[pointer++] & 0xFF) << 8)) != length) {
            throw new IOException("Invalid BGZIP block length");
        }
        int deflatedSize = compressedBlockSize - 18 - 8;
        pointer += deflatedSize + 4;
        int originInputSize = (src[pointer++] & 0xFF) + ((src[pointer++] & 0xFF) << 8) + ((src[pointer++] & 0xFF) << 16) + ((src[pointer++] & 0xFF) << 24);
        this.inflater.reset();
        this.inflater.setInput(src, pointer, deflatedSize);
        try {
            size = this.inflater.inflate(this.cache, 0, originInputSize);
        }
        catch (DataFormatException e) {
            throw new IOException("Invalid BGZIP block");
        }
        if (originInputSize != size) {
            throw new IOException("Invalid BGZIP block length");
        }
        if (size == 0) {
            return Bytes.EMPTY;
        }
        if (this.container != null) {
            this.container.reset(this.cache, 0, size);
            return this.container;
        }
        return new Bytes(this.cache, 0, size, true, false);
    }

    public Bytes inflaterBlock(byte[] src) throws IOException {
        return this.inflaterBlock(src, 0, src.length);
    }

    public Bytes inflaterBlock(Bytes src) throws IOException {
        return this.inflaterBlock(src.bytes(), src.offset(), src.length());
    }
}

