/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io.bgzip;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.io.bgzip.BGZIPConstants;
import java.util.zip.CRC32;
import java.util.zip.Deflater;

public class BGZIPBlockEncoder {
    final ByteStream cache = new ByteStream(65536, true);
    final int level;
    final Bytes container;
    private final CRC32 crc32 = new CRC32();
    private final ByteStream buffer = new ByteStream(65498, false);
    private final Deflater deflater;

    public BGZIPBlockEncoder(boolean share) {
        this(5, share);
    }

    public BGZIPBlockEncoder(int level, boolean share) {
        if (level == -1) {
            this.level = 5;
        } else if (level >= 0 && level <= 9) {
            this.level = level;
        } else {
            throw new IllegalArgumentException("Invalid BGZIP compression level: " + level + ". Valid range is between " + 0 + " and " + 9 + " (inclusive).");
        }
        this.deflater = new Deflater(this.level, true);
        this.container = share ? new Bytes() : null;
    }

    public void write(byte code) {
        this.buffer.write(code);
        if (this.buffer.wRemaining() == 0) {
            this.deflateBlock(this.buffer.bytes(), this.buffer.offset(), this.buffer.length());
            this.buffer.clear();
        }
    }

    public void write(Bytes bytes) {
        this.write(bytes.bytes(), bytes.offset(), bytes.length());
    }

    public void write(byte[] bytes, int offset, int length) {
        while (length > 0) {
            if (this.buffer.rRemaining() == 0 && length >= this.buffer.capacity()) {
                this.deflateBlock(bytes, offset, this.buffer.capacity());
                offset += this.buffer.capacity();
                length -= this.buffer.capacity();
                continue;
            }
            int bytesToWrite = this.buffer.write(bytes, offset, Math.min(length, this.buffer.wRemaining()));
            offset += bytesToWrite;
            length -= bytesToWrite;
            if (this.buffer.wRemaining() != 0) continue;
            this.deflateBlock(this.buffer.bytes(), this.buffer.offset(), this.buffer.length());
            this.buffer.clear();
        }
    }

    public Bytes finish() {
        if (this.buffer.rRemaining() > 0) {
            this.deflateBlock(this.buffer.bytes(), this.buffer.offset(), this.buffer.length());
            this.buffer.clear();
        }
        if (this.cache.length() == 0) {
            return Bytes.EMPTY;
        }
        try {
            if (this.container != null) {
                this.cache.toBytes(this.container);
                Bytes bytes = this.container;
                return bytes;
            }
            Bytes bytes = this.cache.toBytes(true);
            return bytes;
        }
        finally {
            this.cache.clear();
        }
    }

    public void close() {
        if (this.buffer.rRemaining() > 0 || this.cache.rRemaining() > 0) {
            throw new IllegalStateException();
        }
        this.cache.close();
        this.crc32.reset();
        this.deflater.end();
    }

    public int size() {
        return this.cache.length();
    }

    private void deflateBlock(byte[] src, int offset, int length) {
        this.cache.wRequire(65536);
        this.cache.write(BGZIPConstants.MAGIC_CODE);
        int compressedBlockSizePointer = this.cache.wTell();
        this.cache.wSkip(2);
        this.deflater.reset();
        this.deflater.setInput(src, offset, length);
        this.deflater.finish();
        int compressedDataSize = this.deflater.deflate(this.cache.bytes(), this.cache.wTell(), 65510);
        this.cache.wSkip(compressedDataSize);
        this.crc32.reset();
        this.crc32.update(src, offset, length);
        this.cache.putInt((int)this.crc32.getValue());
        this.cache.putInt(length);
        int endPointer = this.cache.wTell();
        this.cache.wSeek(compressedBlockSizePointer);
        this.cache.putShort((short)(compressedDataSize + 18 + 8 - 1));
        this.cache.wSeek(endPointer);
    }
}

