/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io.bgzip;

public class BGZIPConstants {
    public static final int DEFAULT_LEVEL = 5;
    public static final int MIN_LEVEL = 0;
    public static final int MAX_LEVEL = 9;
    public static final byte[] MAGIC_CODE = new byte[]{31, -117, 8, 4, 0, 0, 0, 0, 0, -1, 6, 0, 66, 67, 2, 0};
    public static final byte[] EMPTY_BGZIP_BLOCK = new byte[]{31, -117, 8, 4, 0, 0, 0, 0, 0, -1, 6, 0, 66, 67, 2, 0, 27, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final int MAX_COMPRESSED_BLOCK_SIZE = 65536;
    public static final int BLOCK_HEADER_LENGTH = 18;
    public static final int BLOCK_FOOTER_LENGTH = 8;
    public static final int MAX_COMPRESSED_DATA_SIZE = 65510;
    public static final int NO_COMPRESSION_OVERHEAD = 10;
    public static final int BGZIP_OVERHEAD = 28;
    public static final int MAX_UNCOMPRESSED_BLOCK_SIZE = 65498;

    public static int checkCompressionLevel(int level) {
        if (level == -1 || level >= 0 && level <= 9) {
            return level;
        }
        throw new IllegalArgumentException("Invalid BGZIP compression level: " + level + ". Valid range is between " + 0 + " and " + 9 + " (inclusive).");
    }
}

