/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io.bgzip;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.container.entry.TLongIntEntry;
import edu.sysu.pmglab.io.bgzip.BGZIPBlockDecoder;
import edu.sysu.pmglab.io.reader.IReaderStream;
import edu.sysu.pmglab.io.reader.ISeekableReaderStream;
import java.io.IOException;

public class BGZIPReaderStream
extends IReaderStream {
    protected static final ByteStream EMPTY_READER = new ByteStream();
    protected final ISeekableReaderStream reader;
    protected final BGZIPBlockDecoder decoder = new BGZIPBlockDecoder(true);
    protected ByteStream buffer = EMPTY_READER;
    protected long pointer;

    public BGZIPReaderStream(ISeekableReaderStream reader) throws IOException {
        this.reader = reader;
        this.load();
    }

    protected boolean load() throws IOException {
        Bytes cache;
        do {
            this.pointer = this.reader.tell();
            cache = this.decoder.inflaterBlock(this.reader);
            if (cache != null) continue;
            this.buffer.close();
            this.buffer = EMPTY_READER;
            return false;
        } while (cache.length() <= 0);
        this.buffer.close();
        this.buffer = cache.toByteStream();
        return true;
    }

    @Override
    public int read() throws IOException {
        if (this.buffer.rRemaining() > 0) {
            return this.buffer.read();
        }
        if (this.load()) {
            return this.buffer.read();
        }
        return -1;
    }

    @Override
    public int read(byte[] dst, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (len < 0) {
            throw new IllegalArgumentException(String.valueOf(len));
        }
        int total = 0;
        while (len > 0) {
            if (this.buffer.rRemaining() == 0 && !this.load()) {
                return total == 0 ? -1 : total;
            }
            int byteToWrite = this.buffer.read(dst, off, len);
            len -= byteToWrite;
            off += byteToWrite;
            total += byteToWrite;
        }
        return total == 0 ? -1 : total;
    }

    @Override
    public int available() throws IOException {
        int remaining = this.buffer.rRemaining();
        if (remaining == 0) {
            this.load();
            return this.buffer.rRemaining();
        }
        return remaining;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
        this.buffer.close();
    }

    public TLongIntEntry tell() {
        return new TLongIntEntry(this.pointer, this.buffer.rTell());
    }

    public void seek(long blockPointer, int innerPointer) throws IOException {
        this.reader.seek(blockPointer);
        this.load();
        this.buffer.rSeek(innerPointer);
    }
}

