/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io.bgzip.pbgzip;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.io.bgzip.BGZIPBlockEncoder;
import edu.sysu.pmglab.io.bgzip.BGZIPConstants;
import edu.sysu.pmglab.io.bgzip.pbgzip.IBGZIPWriterStream;
import java.io.IOException;
import java.io.OutputStream;

class BGZIPWriterStream
extends IBGZIPWriterStream {
    static final int BUFFER_SIZE = 0x100000;
    final BGZIPBlockEncoder encoder;
    final OutputStream output;

    public BGZIPWriterStream(OutputStream outputStream2, int compressionLevel) {
        this.encoder = new BGZIPBlockEncoder(compressionLevel, true);
        this.output = outputStream2;
    }

    @Override
    public void write(int b) throws IOException {
        Bytes result;
        this.encoder.write((byte)b);
        if (this.encoder.size() >= 0x100000 && (result = this.encoder.finish()).length() > 0) {
            this.output.write(result.bytes(), result.offset(), result.length());
        }
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        Bytes result;
        this.encoder.write(bytes, offset, length);
        if (this.encoder.size() >= 0x100000 && (result = this.encoder.finish()).length() > 0) {
            this.output.write(result.bytes(), result.offset(), result.length());
        }
    }

    @Override
    public void flush() throws IOException {
        Bytes result = this.encoder.finish();
        if (result.length() > 0) {
            this.output.write(result.bytes(), result.offset(), result.length());
        }
    }

    @Override
    public void close() throws IOException {
        Bytes result = this.encoder.finish();
        if (result.length() > 0) {
            this.output.write(result.bytes(), result.offset(), result.length());
        }
        this.output.write(BGZIPConstants.EMPTY_BGZIP_BLOCK);
        this.output.close();
        this.encoder.close();
    }
}

