/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io.bgzip.pbgzip;

import edu.sysu.pmglab.io.bgzip.pbgzip.BGZIPWriterStream;
import edu.sysu.pmglab.io.bgzip.pbgzip.ParallelBGZIPWriterStream;
import edu.sysu.pmglab.io.bgzip.pbgzip.SharedBGZIPWriterStream;
import edu.sysu.pmglab.io.writer.ChannelWriterStream;
import edu.sysu.pmglab.io.writer.IWriterStream;
import edu.sysu.pmglab.pconsumer.PBGZIPBlockEncoder;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public abstract class IBGZIPWriterStream
extends IWriterStream {
    public static IBGZIPWriterStream instanceOf(File file, int compressionLevel, int threads) throws IOException {
        return IBGZIPWriterStream.instanceOf(new ChannelWriterStream(file), compressionLevel, threads);
    }

    public static IBGZIPWriterStream instanceOf(File file, PBGZIPBlockEncoder encoders) throws IOException {
        return IBGZIPWriterStream.instanceOf(new ChannelWriterStream(file), encoders);
    }

    public static IBGZIPWriterStream instanceOf(OutputStream outputStream2, int compressionLevel, int threads) throws IOException {
        if (threads == 1) {
            return new BGZIPWriterStream(outputStream2, compressionLevel);
        }
        return new ParallelBGZIPWriterStream(outputStream2, compressionLevel, threads);
    }

    public static IBGZIPWriterStream instanceOf(OutputStream outputStream2, PBGZIPBlockEncoder encoders) {
        return new SharedBGZIPWriterStream(outputStream2, encoders);
    }
}

