/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io.bgzip.pbgzip;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.io.bgzip.pbgzip.IBGZIPWriterStream;
import edu.sysu.pmglab.pconsumer.PBGZIPBlockEncoder;
import java.io.IOException;
import java.io.OutputStream;

class ParallelBGZIPWriterStream
extends IBGZIPWriterStream {
    final ByteStream cache = new ByteStream(261992, false);
    final Bytes wrapper = new Bytes();
    final PBGZIPBlockEncoder encoder;
    final OutputStream stream;

    public ParallelBGZIPWriterStream(OutputStream stream, int compressionLevel, int threads) {
        this.encoder = (PBGZIPBlockEncoder)new PBGZIPBlockEncoder(compressionLevel, threads).start();
        this.stream = stream;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.cache.wTell() == this.cache.capacity()) {
            this.flush();
        }
        this.cache.write(b);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        while (length > 0) {
            int bytesToWrite = Math.min(this.cache.wRemaining(), length);
            this.cache.write(bytes, offset, bytesToWrite);
            offset += bytesToWrite;
            length -= bytesToWrite;
            if (this.cache.wTell() != this.cache.capacity()) continue;
            this.flush();
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            if (this.cache.wTell() != 0) {
                this.cache.toBytes(this.wrapper);
                this.encoder.submit(this.wrapper, this.stream);
                this.cache.clear();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.flush();
            this.encoder.close(this.stream);
            this.encoder.stop();
            this.wrapper.reset();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
    }
}

