/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io.file;

import edu.sysu.pmglab.commandParser.converter.IConverter;
import edu.sysu.pmglab.io.file.LiveFile;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.TLinkedHashSet;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public enum Channel {
    INSTANCE;

    private static final Map<String, String> regulars;
    private static final Set<String> channels;

    public static LiveFile get(String key, String relativePath) throws IOException {
        if (key != null && regulars.containsKey(key)) {
            return LiveFile.of(regulars.get(key));
        }
        if (LiveFile.exists(relativePath)) {
            return LiveFile.of(relativePath);
        }
        for (String channel : channels) {
            if (!LiveFile.exists(channel + "/" + relativePath)) continue;
            if (key != null) {
                regulars.put(key, channel + "/" + relativePath);
            }
            return LiveFile.of(regulars.get(key));
        }
        return null;
    }

    public static String get(String key) {
        return regulars.get(key);
    }

    public static void set(String key, String absolutePath) {
        if (key == null) {
            throw new NullPointerException("null key");
        }
        if (absolutePath == null) {
            regulars.remove(key);
        }
        regulars.put(key, absolutePath);
    }

    public static void addChannel(String channel) {
        if (channel != null) {
            channels.add(channel);
        }
    }

    public static void clear() {
        regulars.clear();
        channels.clear();
    }

    static {
        regulars = new THashMap<String, String>();
        channels = new TLinkedHashSet<String>();
    }

    private static enum ChannelConverter implements IConverter<Void>
    {
        INSTANCE;


        @Override
        public Void convert(String name, String ... values2) {
            for (String value : values2) {
                int index = value.indexOf("=");
                if (index == -1) {
                    Channel.addChannel(value);
                    continue;
                }
                Channel.set(value.substring(0, index), value.substring(index + 1));
            }
            return null;
        }
    }
}

