/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io.file;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.io.file.FileType;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.reader.ChannelReaderStream;
import edu.sysu.pmglab.io.reader.ISeekableReaderStream;
import edu.sysu.pmglab.utils.Assert;
import edu.sysu.pmglab.utils.DockerCopyer;
import java.io.File;
import java.io.IOException;

public class DockerFile
extends LiveFile {
    final String path;
    final String name;
    final long length;
    final long lastModifyTime;
    final File tempFile;

    public DockerFile(String containerID, String filePath) throws IOException {
        this(new DockerCopyer(containerID), filePath);
    }

    public DockerFile(DockerCopyer copyer, String filePath) throws IOException {
        Assert.that(copyer != null && filePath != null);
        this.tempFile = RuntimeProperty.createTempFile();
        this.tempFile.deleteOnExit();
        copyer.get(filePath, this.tempFile.getCanonicalPath());
        this.lastModifyTime = this.tempFile.lastModified();
        this.path = "docker://" + copyer.getContainerID() + ":" + filePath;
        this.name = new File(filePath).getName();
        this.length = this.tempFile.length();
    }

    public DockerFile(String path) throws IOException {
        if (path == null || !path.contains(":")) {
            throw new IOException("must specify the container source: <containerID>:<path>");
        }
        String containerID = path.substring(0, path.indexOf(":"));
        DockerCopyer copyer = new DockerCopyer(containerID);
        this.tempFile = RuntimeProperty.createTempFile();
        this.tempFile.deleteOnExit();
        copyer.get(path.substring(containerID.length() + 1), this.tempFile.getCanonicalPath());
        this.lastModifyTime = this.tempFile.lastModified();
        this.path = "docker://" + path;
        this.name = new File(path.substring(containerID.length() + 1)).getName();
        this.length = this.tempFile.length();
    }

    @Override
    public FileType getFileType() {
        return FileType.DOCKER;
    }

    @Override
    public long lastModifyTime() {
        return this.lastModifyTime;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void deleteOnExit() {
    }

    @Override
    public ISeekableReaderStream openAsBinary() throws IOException {
        return new ChannelReaderStream(this.tempFile);
    }
}

