/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io.file;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.container.interval.LongInterval;
import edu.sysu.pmglab.io.file.FileType;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.reader.HttpReaderStream;
import edu.sysu.pmglab.io.reader.ISeekableReaderStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class HTTPFile
extends LiveFile {
    final InetSocketAddress proxy;
    final int timeout;
    final String path;
    final URL url;
    final String name;
    final boolean seekable;
    final long length;
    final long lastModifyTime;
    final OkHttpClient client;

    public HTTPFile(URL address) throws IOException {
        this(address, RuntimeProperty.REMOTE_PROXY, RuntimeProperty.REMOTE_TIME_OUT);
    }

    public HTTPFile(URL url, InetSocketAddress proxy, int timeoutSeconds) throws IOException {
        this.url = url;
        this.name = this.url.getFile().substring(this.url.getFile().lastIndexOf(47) + 1);
        this.path = url.toExternalForm();
        this.proxy = proxy;
        this.timeout = timeoutSeconds;
        this.client = this.buildClient(proxy, timeoutSeconds);
        Request request = new Request.Builder().url(url).header("Range", "bytes=0-").build();
        try (Response response = this.client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Failed to connect: " + response.code());
            }
            this.length = response.header("Content-Length") != null ? Long.parseLong(response.header("Content-Length", "-1")) : -1L;
            this.lastModifyTime = response.header("Last-Modified") != null ? Date.parse(response.header("Last-Modified", "0")) : -1L;
            this.seekable = this.length > 0L;
        }
    }

    public static HttpURLConnection getHttpURLConnection(URL url, InetSocketAddress proxy, LongInterval range, int timeout2) throws IOException {
        HttpURLConnection httpConnection = proxy != null ? (HttpURLConnection)url.openConnection(new Proxy(Proxy.Type.HTTP, proxy)) : (HttpURLConnection)url.openConnection();
        httpConnection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.116 Safari/537.36");
        if (range != null) {
            httpConnection.setRequestProperty("RANGE", "bytes=" + range.start() + "-" + range.end());
        }
        httpConnection.setConnectTimeout(timeout2 * 1000);
        httpConnection.setReadTimeout(timeout2 * 1000);
        return httpConnection;
    }

    private OkHttpClient buildClient(InetSocketAddress proxyAddress, int timeoutSeconds) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(timeoutSeconds, TimeUnit.SECONDS).retryOnConnectionFailure(true);
        if (proxyAddress != null) {
            builder.proxy(new Proxy(Proxy.Type.HTTP, proxyAddress));
        }
        return builder.build();
    }

    @Override
    public FileType getFileType() {
        return FileType.HTTP;
    }

    @Override
    public long lastModifyTime() {
        return this.lastModifyTime;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void deleteOnExit() {
    }

    @Override
    public ISeekableReaderStream openAsBinary() throws IOException {
        return new HttpReaderStream(this);
    }

    public URL getURL() {
        return this.url;
    }

    public InetSocketAddress getProxy() {
        return this.proxy;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean isSeekable() {
        return this.seekable;
    }

    public OkHttpClient getClient() {
        return this.client;
    }
}

