/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io.file;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.io.bgzip.BGZIPConstants;
import edu.sysu.pmglab.io.bgzip.BGZIPReaderStream;
import edu.sysu.pmglab.io.file.DockerFile;
import edu.sysu.pmglab.io.file.FileType;
import edu.sysu.pmglab.io.file.HTTPFile;
import edu.sysu.pmglab.io.file.LocalFile;
import edu.sysu.pmglab.io.file.SFTPFile;
import edu.sysu.pmglab.io.reader.GZIPReaderStream;
import edu.sysu.pmglab.io.reader.ISeekableReaderStream;
import edu.sysu.pmglab.io.reader.ReaderStream;
import edu.sysu.pmglab.io.writer.WriterStream;
import edu.sysu.pmglab.progressbar.unit.DataLengthUnit;
import edu.sysu.pmglab.utils.DockerCopyer;
import edu.sysu.pmglab.utils.MD5;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.file.FileAlreadyExistsException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class LiveFile {
    AtomicBoolean isGZCompressed;
    AtomicBoolean isBGZCompressed;

    public static LiveFile of(String address) throws IOException {
        if (address == null) {
            throw new NullPointerException("Invalid file path: null");
        }
        if (address.startsWith("http://") || address.startsWith("https://")) {
            return new HTTPFile(new URL(address), RuntimeProperty.REMOTE_PROXY, RuntimeProperty.REMOTE_TIME_OUT);
        }
        if (address.startsWith("docker://")) {
            return new DockerFile(address.substring("docker://".length()));
        }
        if (address.startsWith("sftp://")) {
            return new SFTPFile(address);
        }
        if (address.startsWith("file://")) {
            return new LocalFile(address.substring("file://".length()));
        }
        return new LocalFile(address);
    }

    public static FileType getProtocol(String address) {
        if (address.startsWith("http://") || address.startsWith("https://")) {
            return FileType.HTTP;
        }
        if (address.startsWith("docker://")) {
            return FileType.DOCKER;
        }
        if (address.startsWith("sftp://")) {
            return FileType.SFTP;
        }
        if (address.startsWith("packed://")) {
            return FileType.PACKED;
        }
        return FileType.LOCAL;
    }

    public static LiveFile of(SFTPFile.Path path) throws IOException {
        return new SFTPFile(path);
    }

    public static LiveFile of(DockerCopyer copyer, String address) throws IOException {
        return new DockerFile(copyer, address);
    }

    public static LiveFile of(File address) throws IOException {
        return new LocalFile(address);
    }

    public static LiveFile of(URL address, InetSocketAddress proxy, int timeout2) throws IOException {
        return new HTTPFile(address, proxy, timeout2);
    }

    public static boolean exists(String path) {
        try {
            LiveFile liveFile = LiveFile.of(path);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public abstract FileType getFileType();

    public abstract long lastModifyTime();

    public abstract long length();

    public abstract String getPath();

    public abstract String getName();

    public final boolean withExtension(String ... extensions) {
        if (extensions == null) {
            return false;
        }
        String name = this.getName();
        if (name == null) {
            return false;
        }
        for (String extension : extensions) {
            if (!extension.startsWith(".")) {
                extension = "." + extension;
            }
            if (!name.endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    public final String formatLastModifyTime(String format) {
        return new SimpleDateFormat(format == null ? "yyyy-MM-dd hh:mm:ss" : format, Locale.US).format(this.lastModifyTime());
    }

    public final String formatLength(String format) {
        return DataLengthUnit.B.convert(this.length(), new DecimalFormat(format == null ? "#.###" : format, new DecimalFormatSymbols(Locale.US)));
    }

    public final boolean isGZCompressed() throws IOException {
        if (this.isGZCompressed == null) {
            this.checkGZMarginCode();
        }
        return this.isGZCompressed.get();
    }

    public boolean isBGZCompressed() throws IOException {
        if (this.isBGZCompressed == null) {
            this.checkGZMarginCode();
        }
        return this.isBGZCompressed.get();
    }

    private void checkGZMarginCode() throws IOException {
        if (this.isBGZCompressed == null && this.isGZCompressed == null) {
            try (ISeekableReaderStream tempReader = this.openAsBinary();){
                Bytes magicCode = tempReader.readBytes(BGZIPConstants.MAGIC_CODE.length);
                if (magicCode.length() < 2) {
                    this.isGZCompressed = new AtomicBoolean(false);
                    this.isBGZCompressed = new AtomicBoolean(false);
                } else {
                    this.isGZCompressed = new AtomicBoolean((magicCode.subBytes(0, 2).decodeShort() & 0xFFFF) == 35615);
                    this.isBGZCompressed = new AtomicBoolean(magicCode.valueEquals(BGZIPConstants.MAGIC_CODE));
                }
            }
        }
    }

    public final int hashCode() {
        return Objects.hash(this.getPath().hashCode(), this.lastModifyTime(), this.length());
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LiveFile liveFile = (LiveFile)o;
        return Objects.equals(this.getPath(), liveFile.getPath()) && Objects.equals(this.lastModifyTime(), liveFile.lastModifyTime()) && Objects.equals(this.length(), liveFile.length());
    }

    public String toString() {
        return this.getPath();
    }

    public abstract void deleteOnExit() throws IOException;

    public abstract ISeekableReaderStream openAsBinary() throws IOException;

    public final ReaderStream openAsText() throws IOException {
        if (this.isBGZCompressed()) {
            return new ReaderStream(new BGZIPReaderStream(this.openAsBinary()));
        }
        if (this.isGZCompressed()) {
            return new ReaderStream(new GZIPReaderStream(this.openAsBinary()));
        }
        return new ReaderStream(this.openAsBinary());
    }

    public String md5() throws IOException {
        try (ISeekableReaderStream reader = this.openAsBinary();){
            String string = MD5.check(reader);
            return string;
        }
    }

    public final LiveFile copyFileTo(File targetPath) throws IOException {
        int len;
        if (targetPath.exists()) {
            throw new FileAlreadyExistsException(targetPath.toString());
        }
        WriterStream writer = new WriterStream(targetPath, WriterStream.Option.DEFAULT);
        ISeekableReaderStream reader = this.openAsBinary();
        byte[] cache = new byte[8192];
        while ((len = reader.read(cache)) != -1) {
            writer.write(cache, 0, len);
        }
        reader.close();
        writer.close();
        return new LocalFile(targetPath);
    }
}

