/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io.file;

import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.io.file.FileType;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.reader.ChannelReaderStream;
import edu.sysu.pmglab.io.reader.ISeekableReaderStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.NoSuchFileException;

public class LocalFile
extends LiveFile {
    final String path;
    final String name;
    final long length;
    final long lastModifyTime;

    public LocalFile(File file) throws IOException {
        if (!file.exists()) {
            throw new NoSuchFileException("File not found: " + file);
        }
        if (file.isDirectory()) {
            throw new IOException("Directory: " + file);
        }
        this.length = file.length();
        this.lastModifyTime = file.lastModified();
        this.path = file.getCanonicalPath();
        this.name = file.getName();
    }

    public LocalFile(String path) throws IOException {
        this(new File(path));
    }

    @Override
    public FileType getFileType() {
        return FileType.LOCAL;
    }

    @Override
    public long lastModifyTime() {
        return this.lastModifyTime;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void deleteOnExit() throws IOException {
        FileUtils.delete(this.getPath());
    }

    @Override
    public ISeekableReaderStream openAsBinary() throws IOException {
        return new ChannelReaderStream(new File(this.path));
    }

    public File getFile() {
        return new File(this.path);
    }
}

