/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io.file;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.ProxySOCKS5;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.io.file.FileType;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.reader.ISeekableReaderStream;
import edu.sysu.pmglab.io.reader.SFTPReaderStream;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SFTPFile
extends LiveFile {
    final InetSocketAddress proxy;
    final int timeout;
    final Path path;
    final long length;
    final long lastModifyTime;

    public SFTPFile(Path address) throws IOException {
        this(address, RuntimeProperty.REMOTE_PROXY, RuntimeProperty.REMOTE_TIME_OUT);
    }

    public SFTPFile(Path path, InetSocketAddress proxy, int timeout2) throws IOException {
        this.proxy = proxy;
        this.timeout = timeout2;
        this.path = path;
        try {
            Session session = this.createSession();
            ChannelSftp sftpChannel = (ChannelSftp)session.openChannel("sftp");
            sftpChannel.connect();
            SftpATTRS attrs = sftpChannel.lstat(path.remotePath);
            this.length = attrs.getSize();
            this.lastModifyTime = attrs.getMTime();
            sftpChannel.disconnect();
            session.disconnect();
        }
        catch (JSchException | SftpException e) {
            throw new IOException(e);
        }
    }

    public SFTPFile(String address) throws IOException {
        this(new Path(address));
    }

    public SFTPFile(String address, InetSocketAddress proxy, int timeout2) throws IOException {
        this(new Path(address), proxy, timeout2);
    }

    public SFTPFile(String host, int port, String username, String password, String remotePath) throws IOException {
        this(new Path(host, port, username, password, remotePath));
    }

    public SFTPFile(String host, int port, String username, String password, String remotePath, InetSocketAddress proxy, int timeout2) throws IOException {
        this(new Path(host, port, username, password, remotePath), proxy, timeout2);
    }

    public Session createSession() throws JSchException {
        JSch jsch = new JSch();
        Session session = jsch.getSession(this.path.username, this.path.host, this.path.port);
        if (this.proxy != null) {
            session.setProxy(new ProxySOCKS5(this.proxy.getHostName(), this.proxy.getPort()));
        }
        session.setConfig("StrictHostKeyChecking", "no");
        session.setPassword(this.path.password);
        session.setTimeout(this.timeout * 1000);
        session.connect();
        return session;
    }

    @Override
    public FileType getFileType() {
        return FileType.SFTP;
    }

    @Override
    public long lastModifyTime() {
        return this.lastModifyTime;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public String getPath() {
        return this.path.path;
    }

    @Override
    public String getName() {
        return this.path.name;
    }

    @Override
    public void deleteOnExit() throws IOException {
    }

    @Override
    public ISeekableReaderStream openAsBinary() throws IOException {
        return new SFTPReaderStream(this);
    }

    public Path getSFTPPath() {
        return this.path;
    }

    public static class Path {
        public final String host;
        public final int port;
        public final String username;
        public final String password;
        public final String remotePath;
        public final String path;
        public final String name;

        public Path(String address) throws IOException {
            String password;
            String username;
            String regex = "^sftp://(?:([^:]+):([^@]+)@)?([^:/]+)(?::(\\d+))?/(.*)$";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(address);
            if (matcher.find()) {
                username = matcher.group(1);
                password = matcher.group(2);
                this.host = matcher.group(3);
                this.port = matcher.group(4) == null || matcher.group(4).length() == 0 ? 22 : Integer.parseInt(matcher.group(4));
                this.remotePath = matcher.group(5);
                this.name = new File(this.remotePath).getName();
                if (username == null || password == null) {
                    throw new IOException("Missing username or password in SFTP path format: sftp://<user>:<password>@<serve>[:<port>]/<path>");
                }
            } else {
                throw new IOException("Incorrect SFTP path format: sftp://<user>:<password>@<serve>[:<port>]/<path>");
            }
            this.username = username;
            this.password = password;
            this.path = "sftp://" + username + ":" + password + "@" + this.host + ":" + this.port + "/" + this.remotePath;
        }

        public Path(String host, int port, String username, String password, String remotePath) {
            this.host = host;
            this.port = port;
            this.username = username;
            this.password = password;
            this.remotePath = remotePath;
            this.name = new File(this.remotePath).getName();
            this.path = "sftp://" + username + ":" + password + "@" + host + ":" + port + "/" + remotePath;
        }

        public String toString() {
            return this.path;
        }
    }
}

