/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io.partreader;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.container.entry.TLongIntEntry;
import edu.sysu.pmglab.container.interval.Interval;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.io.bgzip.BGZIPBoundReaderStream;
import edu.sysu.pmglab.io.bgzip.BGZIPReaderStream;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.partreader.IPartReader;
import edu.sysu.pmglab.io.reader.ISeekableReaderStream;
import edu.sysu.pmglab.io.reader.ReaderStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;

public class BGZPartReader
implements IPartReader {
    final BGZIPReaderStream reader;
    final LiveFile file;
    final AtomicBoolean isPart = new AtomicBoolean(false);
    final ByteStream line = new ByteStream(8192, true);
    byte[] ioStreamCache = new byte[65540];

    BGZPartReader(LiveFile file) throws IOException {
        this.reader = new BGZIPReaderStream(file.openAsBinary());
        this.file = file;
    }

    @Override
    public List<ReaderStream> part(int nParts) throws IOException {
        if (this.isPart.get()) {
            throw new IOException("This reader has been taken over by the chunked reader");
        }
        long currentSeek = this.reader.tell().getKey();
        long resSize = this.file.length() - currentSeek;
        if (nParts == 1 || resSize <= 0x100000L) {
            this.isPart.set(true);
            return List.wrap(new ReaderStream[]{new ReaderStream(this.reader)});
        }
        long eachBlockSize = resSize / (long)nParts + (long)(resSize % (long)nParts == 0L ? 0 : 1);
        long startBound = currentSeek;
        long endBound = currentSeek + eachBlockSize;
        int startPointer = this.reader.tell().getValue();
        List<ReaderStream> readers = new List<ReaderStream>();
        ISeekableReaderStream adjuster = this.file.openAsBinary();
        while (startBound < endBound) {
            adjuster.seek(endBound);
            long p = this.findBlock(adjuster);
            if (p == -1L) break;
            this.reader.seek(p, 0);
            this.readline();
            TLongIntEntry pointer = this.reader.tell();
            endBound = pointer.getKey();
            int endPointer = pointer.getValue();
            readers.add(new ReaderStream(new BGZIPBoundReaderStream(this.file.openAsBinary(), new Interval<TLongIntEntry>(new TLongIntEntry(startBound, startPointer), new TLongIntEntry(endBound, endPointer)))));
            startBound = endBound;
            startPointer = endPointer;
            if ((endBound += eachBlockSize) < currentSeek + resSize) continue;
            readers.add(new ReaderStream(new BGZIPBoundReaderStream(this.file.openAsBinary(), new Interval<TLongIntEntry>(new TLongIntEntry(startBound, startPointer), new TLongIntEntry(currentSeek + resSize, 0)))));
            break;
        }
        adjuster.close();
        this.reader.close();
        this.isPart.set(true);
        return readers;
    }

    @Override
    public Bytes readline() throws IOException {
        if (this.isPart.get()) {
            throw new IOException("This reader has been taken over by the chunked reader");
        }
        ByteStream cache = ByteStream.getThreadInstance();
        if (this.readline(cache) != -1) {
            return cache.toBytes(true);
        }
        return null;
    }

    @Override
    public int readline(ByteStream line) throws IOException {
        if (this.isPart.get()) {
            throw new IOException("This reader has been taken over by the chunked reader");
        }
        int size = line.length();
        while (true) {
            int b;
            if ((b = this.reader.read()) == 10) {
                if (line.wTell() > 0 && line.bytes()[line.wTell() - 1] == 13) {
                    line.wSeek(line.wTell() - 1);
                }
                return line.length() - size;
            }
            if (b == -1) {
                int off = line.length() - size;
                return off == 0 ? -1 : off;
            }
            line.write(b);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.isPart.get()) {
            throw new IOException("This reader has been taken over by the chunked reader");
        }
        this.reader.close();
    }

    public long findBlock(ISeekableReaderStream adjuster) throws IOException {
        int accept = adjuster.read(this.ioStreamCache);
        if (accept == -1) {
            return -1L;
        }
        for (int index = 0; index < accept - 4; ++index) {
            if (this.ioStreamCache[index] != 31 || this.ioStreamCache[index + 1] != -117 || this.ioStreamCache[index + 2] != 8 || this.ioStreamCache[index + 3] != 4) continue;
            long pointer = adjuster.tell() - (long)accept + (long)index;
            adjuster.seek(pointer);
            return pointer;
        }
        return -1L;
    }
}

