/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.io.partreader;

import edu.sysu.pmglab.container.interval.LongInterval;
import edu.sysu.pmglab.io.reader.ISeekableReaderStream;
import edu.sysu.pmglab.utils.ValueUtils;
import java.io.IOException;

public class BoundReader
extends ISeekableReaderStream {
    final ISeekableReaderStream reader;
    final LongInterval range;
    long pointer;

    public BoundReader(ISeekableReaderStream reader, LongInterval range) throws IOException {
        this.reader = reader;
        long start = ValueUtils.valueOf(range.start(), 0L, this.reader.length());
        long end = ValueUtils.valueOf(range.end(), start, this.reader.length());
        this.range = new LongInterval(start, end);
        this.reader.seek(start);
        this.pointer = start;
    }

    @Override
    public int read(byte[] dst, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        len = Math.min(this.available(), len);
        if (len == 0) {
            return -1;
        }
        int length0 = this.reader.read(dst, off, len);
        if (length0 == -1) {
            return -1;
        }
        this.pointer += (long)length0;
        return length0;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void seek(long pos) throws IOException {
        long pointer = ValueUtils.valueOf(pos, this.range.start(), this.range.end());
        try {
            this.reader.seek(pointer);
        }
        finally {
            this.pointer = pointer;
        }
    }

    @Override
    public long tell() throws IOException {
        return this.pointer;
    }

    @Override
    public long length() throws IOException {
        return this.range.end() - this.range.start();
    }

    @Override
    public long skip(long n) throws IOException {
        if (n == 0L) {
            return 0L;
        }
        long before = this.tell();
        this.seek(before + n);
        return this.tell() - before;
    }

    @Override
    public int available() throws IOException {
        long res = this.range.end() - this.pointer;
        if (res > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)res;
    }

    public LongInterval range() {
        return this.range;
    }
}

